/********************************************************************
 *         This example code is from the book:
 *
 *           Motif Debuggin and Performance Tuning
 *            ISBN 0-13-147984-9
 *         by
 *           Douglas Young
 *           Prentice Hall, 1995
 *
 *         Copyright 1994 by Prentice Hall
 *         All Rights Reserved
 *
 *  Permission to use, copy, modify, and distribute this software for 
 *  any purpose except publication and without fee is hereby granted, provided 
 *  that the above copyright notice appear in all copies of the software.
 * *****************************************************************************/

/*********************************************************
 * menu.c: menu construction and callbacks for dirview
 *********************************************************/
#include <Xm/Xm.h>
#include <Xm/RowColumn.h>
#include <Xm/CascadeB.h>
#include <Xm/PushB.h>
#include <stdlib.h>

extern void  OpenSelected ( void );

/*
 * Callback functions
 */

static void QuitCallback ( Widget    w,
                           XtPointer clientData,
                           XtPointer callData )
{
    exit ( 0 );
}

static void OpenSelectedCallback ( Widget    w,
                                   XtPointer clientData,
                                   XtPointer callData )
{
    OpenSelected();
}


void CreateFilePane ( Widget parent ) 
{
    Widget cascade, submenu, quit, openNew;
    int    i;

   /*
    * Install a File menu pane. Initially contains 
    * only a Quit item.
    */

    submenu = XmCreatePulldownMenu ( parent, 
                                    "File", 
                                     NULL, 0 );

    cascade = XtVaCreateManagedWidget ( "File",
                                    xmCascadeButtonWidgetClass,
                                    parent, 
                                    XmNsubMenuId, submenu,
                                    NULL );

    quit = XtCreateManagedWidget ( "Quit",
                                   xmPushButtonWidgetClass,
                                   submenu, NULL, 0 );

    XtAddCallback ( quit, XmNactivateCallback,
                    QuitCallback, NULL ); 
}

void CreateActionsPane ( Widget parent ) 
{
    Widget cascade, submenu, openSelected;

   /*
    * Install an "Action" menu pane. Initially contains 
    * only an "Open" item.
    */

    submenu = XmCreatePulldownMenu ( parent, 
                                    "Actions", 
                                     NULL, 0 );

    cascade = XtVaCreateManagedWidget ( "Actions",
                                   xmCascadeButtonWidgetClass,
                                   parent, 
                                   XmNsubMenuId, submenu,
                                   NULL  );
    
    openSelected = XtCreateManagedWidget ( "Open",
                                     xmPushButtonWidgetClass,
                                     submenu, NULL, 0 );

    XtAddCallback ( openSelected, XmNactivateCallback,
                    OpenSelectedCallback, NULL ); 
}

Widget CreateMenu ( Widget parent ) 
{
    Widget menu;
    int i;

   /*
    * Create a menu bar and call convenience functions
    * to create each pane.
    */

    menu = XmCreateMenuBar ( parent, "menuBar", NULL, 0 );

    CreateFilePane ( menu );
    CreateActionsPane ( menu );

    XtManageChild ( menu );

    return ( menu );
}

