/********************************************************************
 *         This example code is from the book:
 *
 *           Motif Debuggin and Performance Tuning
 *            ISBN 0-13-147984-9
 *         by
 *           Douglas Young
 *           Prentice Hall, 1995
 *
 *         Copyright 1994 by Prentice Hall
 *         All Rights Reserved
 *
 *  Permission to use, copy, modify, and distribute this software for 
 *  any purpose except publication and without fee is hereby granted, provided 
 *  that the above copyright notice appear in all copies of the software.
 * *****************************************************************************/

/****************************************
 * cursors.c: Create busy cursors
 *****************************************/
#include <Xm/Xm.h>

#define cursor_width 16
#define cursor_height 16
static unsigned char cursor_bits[] = {
   0xc0, 0x01, 0xf0, 0x07, 0xfc, 0x1f, 0xfc, 0x1f, 0xf2, 0x27, 
   0xe2, 0x23, 0xc1, 0x41, 0x81, 0x40, 0xc1, 0x41, 0xe2, 0x23,
   0xf2, 0x27, 0xfc, 0x1f, 0xfc, 0x1f, 0xf0, 0x07, 0xc0, 0x01,
   0x00, 0x00 };
static unsigned char cursor2_bits[] = {
   0xc0, 0x01, 0x30, 0x06, 0x0c, 0x18, 0x0c, 0x18, 0x1e, 0x3c,
   0x3e, 0x3e, 0x7f, 0x7f, 0xff, 0x7f, 0x7f, 0x7f, 0x3e, 0x3e,
   0x1e, 0x3c, 0x0c, 0x18, 0x0c, 0x18, 0x30, 0x06, 0xc0, 0x01,
   0x00, 0x00 };

static Cursor cursors[2];
static int currentCursor = -1;

void DisplayBusyCursor ( Widget w ) 
{
  Display *dpy    = XtDisplay ( w );
  
   /*
    * Create the busy cursors if this is the first call.
    */

    if ( currentCursor < 0 )
    {
        XColor   xcolors[2];
        Pixmap   pm;

        Screen  *scr    = DefaultScreenOfDisplay ( dpy );
        Colormap cmap   = DefaultColormapOfScreen ( scr );
        Window   root   = DefaultRootWindow ( dpy );
        xcolors[0].pixel= BlackPixel ( XtDisplay ( w ), 0 );
        xcolors[1].pixel= WhitePixel ( XtDisplay ( w ), 0 );

       /*
        * Retrieve XColor structures needed 
        * by XCreatePixmapCursor
        */

        XQueryColors ( XtDisplay ( w ), cmap, xcolors, 2 );

       /*
        * Create each cursor by creating a pixmap
        * that can be converted to a cursor.
        */

        pm = XCreateBitmapFromData ( dpy, root,
                                     cursor_bits, 
                                     cursor_width, 
                                     cursor_height );

        cursors[0] = XCreatePixmapCursor ( dpy, pm, pm,
                                           &xcolors[0], 
                                           &xcolors[1],
                                           0, 0 );
        XFreePixmap ( dpy, pm );
        
        pm = XCreateBitmapFromData ( dpy, root,
                                     cursor2_bits,
                                     cursor_width,
                                     cursor_height );

        cursors[1] = XCreatePixmapCursor ( dpy, pm, pm,
                                           &xcolors[0],
                                           &xcolors[1],
                                           0, 0 );
        XFreePixmap ( dpy, pm );

        currentCursor = 1;
    }

   /*
    * Once the cursors exist, just call XDefintCursor to
    * display a busy cursor. Toggle between the two cursors
    * to produce an animation effect.
    */

    currentCursor = !currentCursor;
  
    XDefineCursor ( dpy, XtWindow ( w ),
                    cursors[currentCursor] );
   /*
    * Unless we flush server requests, the cursor may not 
    * take effect until we are no longer busy.
    */

    XFlush ( dpy );
}

void HideBusyCursor ( Widget w )
{
    XUndefineCursor ( XtDisplay ( w ), XtWindow ( w ) );
}

