/********************************************************************
 *         This example code is from the book:
 *
 *           Motif Debuggin and Performance Tuning
 *            ISBN 0-13-147984-9
 *         by
 *           Douglas Young
 *           Prentice Hall, 1995
 *
 *         Copyright 1994 by Prentice Hall
 *         All Rights Reserved
 *
 *  Permission to use, copy, modify, and distribute this software for 
 *  any purpose except publication and without fee is hereby granted, provided 
 *  that the above copyright notice appear in all copies of the software.
 * *****************************************************************************/

/******************************************************
 * globals.h: Common definitions needed in dirview.
 ******************************************************/
#include <sys/stat.h>
#include <dirent.h>

/* 
 * Define symbols for types of files.
 */

typedef enum { REGULAR_FILE, DIRECTORY } FileType;

/*
 * Convenient macros for checking type of a file/directory
 */

static struct stat Statbuf;

#define exists(file) (stat(file,&Statbuf)<0 ?     \
                      0:Statbuf.st_mode)
#define GetType(name)(exists(name) &&             \
                       S_ISDIR(Statbuf.st_mode) ? \
                       DIRECTORY :                \
                       REGULAR_FILE)

