/********************************************************************
 *         This example code is from the book:
 *
 *           Motif Debuggin and Performance Tuning
 *            ISBN 0-13-147984-9
 *         by
 *           Douglas Young
 *           Prentice Hall, 1995
 *
 *         Copyright 1994 by Prentice Hall
 *         All Rights Reserved
 *
 *  Permission to use, copy, modify, and distribute this software for 
 *  any purpose except publication and without fee is hereby granted, provided 
 *  that the above copyright notice appear in all copies of the software.
 * *****************************************************************************/

/******************************************
 * launch.c: launch subprocesses to view a
 *           file or directory
 *******************************************/
#include <stdlib.h>
#include <unistd.h>
#include <Xm/Xm.h>


void LaunchEditor ( Display *dpy, char *file )
{
   /*
    * Find out what editor the user wants to use.
    */

    char *editor = getenv ( "EDITOR" );
  
    if ( fork() == 0 ) /* If in the child */
    {
        char *args[3];

       /*
        * Overlay the child process with the editor process
        * before exiting the current process.
        */

        args[0] = editor;
        args[1] = file;
        args[2] = NULL;            

        close ( ConnectionNumber ( dpy ) );
        execvp ( editor, args );
        exit ( -1 );
    }
}
void LaunchNewBrowser ( Display *dpy, char *file )
{
    if ( fork() == 0 ) /* If in the child */
    {
        char *args[3];

       /*
        * Overlay the child process with a new dirview 
        * process before exiting the current process.
        */

        args[0] = "dirview";
        args[1] = file;
        args[2] = NULL;            

        close ( ConnectionNumber ( dpy ) );
        execvp ( "dirview", args );
        exit ( -1 );
    }
}

