/********************************************************************
 *         This example code is from the book:
 *
 *           Motif Debuggin and Performance Tuning
 *            ISBN 0-13-147984-9
 *         by
 *           Douglas Young
 *           Prentice Hall, 1995
 *
 *         Copyright 1994 by Prentice Hall
 *         All Rights Reserved
 *
 *  Permission to use, copy, modify, and distribute this software for 
 *  any purpose except publication and without fee is hereby granted, provided 
 *  that the above copyright notice appear in all copies of the software.
 * *****************************************************************************/

/********************************************
 * icons.c: Functions for creating icons
 ********************************************/
#include <Xm/Xm.h>
#include <Xm/RowColumn.h>
#include <Xm/LabelG.h>
#include <Xm/PushBG.h>
#include <X11/xpm.h>
#include "icons.h"
#include "globals.h"

extern void SetSelectedWidget(Widget w);
extern void OpenSelected(void);


static Pixmap filePixmap = NULL;
static Pixmap dirPixmap = NULL;

static void SelectCallback ( Widget    w,
                             XtPointer clientData,
                             XtPointer callData)
{
    XmPushButtonCallbackStruct *cbs =
                   ( XmPushButtonCallbackStruct * ) callData;

   /*
    * Always register this icon as the current selected widget.
    */

    SetSelectedWidget ( w );

   /*
    * Open on a double-click
    */

    if ( cbs->click_count > 1 )
        OpenSelected();
}

Pixmap CreatePixmap ( Widget w, FileType type )
{
    int            status;
    Pixmap         pix, mask;
    XpmAttributes  attributes;
    XpmColorSymbol symbols[5];
    Display       *dpy = XtDisplay(w);
    Pixel          bg;

   /*
    * Retrieve the depth and colormap used by this widget
    * and store the results in the corresponding field
    * of an XpmAttributes structure.
    */

    XtVaGetValues ( w,
                    XmNdepth,    &attributes.depth,
                    XmNcolormap, &attributes.colormap,
                    XmNbackground, &bg,
                    NULL );

    symbols[0].name  = "background";
    symbols[0].value = NULL;
    symbols[0].pixel = bg;  

   /*
    * Specify the visual and set the XpmAttributes mask.
    */

    attributes.visual = DefaultVisual ( dpy, 
                                        DefaultScreen ( dpy ) );
    attributes.valuemask =  XpmColorSymbols | XpmDepth |
                            XpmColormap | XpmVisual;

    attributes.colorsymbols = symbols;
    attributes.numsymbols   = 1;

   /*
    * Create the pixmap
    */

    status = XpmCreatePixmapFromData ( dpy,
                    DefaultRootWindow ( dpy ), 
                    type == REGULAR_FILE ? fileIcon : dirIcon,
                    &pix, NULL, &attributes );
    return ( pix );
}


Pixmap GetFilePixmap ( Widget w )
{
    if ( !filePixmap )
        filePixmap = CreatePixmap ( w, REGULAR_FILE );

    return ( filePixmap );
}

Pixmap GetDirPixmap ( Widget w )
{
    if ( !dirPixmap )
        dirPixmap = CreatePixmap ( w, DIRECTORY );

    return ( dirPixmap );
}

static  GC gc = NULL;
static  GC inverseGc = NULL;
static int depth = 0;
 
Widget CreateIcon ( char * name, Widget parent,
                    FileType type, Widget existing )
{
    Widget icon;
    Pixmap pix;

    if ( type == REGULAR_FILE )
       pix = GetFilePixmap ( parent );
    else
       pix = GetDirPixmap(parent);


    if ( existing )
    {
        icon = existing;

        XtVaSetValues ( icon,
                        XtVaTypedArg, XmNlabelString,
                        XmRString,
                        name, strlen ( name )+1,
                        XmNlabelPixmap, pix,
                        NULL );
  }
  else
  {
      icon = XtVaCreateWidget ( name,
                                xmPushButtonGadgetClass,
                                parent,
                                XmNlabelType, XmPIXMAP,
                                XmNlabelPixmap, pix,
                                XmNshadowThickness, 0,
                                XmNfillOnArm, FALSE,
                                NULL);

      XtAddCallback ( icon, XmNactivateCallback,
                      SelectCallback, NULL );
  }
   return ( icon );
}
