/********************************************************************
 *         This example code is from the book:
 *
 *           Motif Debuggin and Performance Tuning
 *            ISBN 0-13-147984-9
 *         by
 *           Douglas Young
 *           Prentice Hall, 1995
 *
 *         Copyright 1994 by Prentice Hall
 *         All Rights Reserved
 *
 *  Permission to use, copy, modify, and distribute this software for 
 *  any purpose except publication and without fee is hereby granted, provided 
 *  that the above copyright notice appear in all copies of the software.
 * *****************************************************************************/

/////////////////////////
// Canvas.h
/////////////////////////

#include <Xm/Xm.h>

class Canvas {
    public:
        Canvas ( const char *name, Widget parent );
        ~Canvas();
        void setColor ( int r, int g, int b );

     private:
        Widget _frame;
        Widget _canvas;

    // other internal data, widgets, functions
};

////////////////////////
// Canvas.C: 
////////////////////////
#include <Xm/Xm.h>
#include <Xm/Frame.h>
#include <Xm/DrawingA.h>
#include "Canvas.h"


Canvas::Canvas ( const char *name, Widget parent )
{
    _frame = XtCreateManagedWidget ( name,
                                     xmFrameWidgetClass,
                                     parent, NULL, 0 );

    _canvas = XtCreateManagedWidget ( "canvas",
                                      xmDrawingAreaWidgetClass,
                                      frame, NULL, 0 );
    // Add callbacks, etc.
}

