/********************************************************************
 *         This example code is from the book:
 *
 *           Motif Debuggin and Performance Tuning
 *            ISBN 0-13-147984-9
 *         by
 *           Douglas Young
 *           Prentice Hall, 1995
 *
 *         Copyright 1994 by Prentice Hall
 *         All Rights Reserved
 *
 *  Permission to use, copy, modify, and distribute this software for 
 *  any purpose except publication and without fee is hereby granted, provided 
 *  that the above copyright notice appear in all copies of the software.
 * *****************************************************************************/

/***********************************************************
 * ColorControl.c: ColorControl module for draw program.
  *********************************************************/
#include <Xm/Xm.h>
#include <Xm/Frame.h>
#include <Xm/RowColumn.h>
#include <Xm/Label.h>
#include <Xm/PushB.h>
#include "Canvas.h" /* Canvas module interface */

static void SelectColorCallback ( Widget,
                                  XtPointer,
                                  XtPointer );

Widget CreateColors ( char *name, Widget parent )
{
    Widget frame, colorlabel, rowColumn, red, green, blue;

   /*
    * Create a labeled frame for all widgets.
    */
  
    frame = XtCreateManagedWidget ( name,
                                    xmFrameWidgetClass,
                                    parent, NULL, 0 );

    colorlabel = XtVaCreateManagedWidget ( "colorlabel",
                            xmLabelWidgetClass, frame,
                            XmNchildType, XmFRAME_TITLE_CHILD,
                            NULL );
   /*
    * Place the three color buttons in a row column widget.
    */

    rowColumn = XtVaCreateManagedWidget ( "rowColumn",
                                  xmRowColumnWidgetClass,
                                  frame,
                                  XmNorientation, XmHORIZONTAL,
                                  NULL );
  
    red = XtCreateManagedWidget ( "red",
                                  xmPushButtonWidgetClass,
                                  rowColumn, NULL, 0 );

    XtAddCallback ( red, XmNactivateCallback, 
                    SelectColorCallback, "red" );

    green = XtCreateManagedWidget ( "green",
                                    xmPushButtonWidgetClass,
                                    rowColumn, NULL, 0 );

    XtAddCallback ( red, XmNactivateCallback, 
                    SelectColorCallback, "green" );

    blue = XtCreateManagedWidget ( "blue",
                                   xmPushButtonWidgetClass,
                                   rowColumn, NULL, 0 );

    XtAddCallback ( red, XmNactivateCallback, 
                    SelectColorCallback, "blue" );

    return ( frame );
}

static void SelectColorCallback ( Widget    w, 
                                  XtPointer clientData,
                                  XtPointer callData )
{
    char      *colorName = ( char * ) clientData;
    Display   *dpy     = XtDisplay ( w );
    int        scr     = DefaultScreen ( dpy );
    Colormap   cmap    = DefaultColormap ( dpy, scr );
    XColor     color, ignore;

   /* 
    * Allocate the named color and retrieve
    * the color components.
    */

    XAllocNamedColor ( dpy, cmap, colorName, 
		       &color, &ignore );

    SetColor ( color.red, color.green, color.blue );
}

