/********************************************************************
 *         This example code is from the book:
 *
 *           Motif Debuggin and Performance Tuning
 *            ISBN 0-13-147984-9
 *         by
 *           Douglas Young
 *           Prentice Hall, 1995
 *
 *         Copyright 1994 by Prentice Hall
 *         All Rights Reserved
 *
 *  Permission to use, copy, modify, and distribute this software for 
 *  any purpose except publication and without fee is hereby granted, provided 
 *  that the above copyright notice appear in all copies of the software.
 * *****************************************************************************/

/**************************************
 * CompleteFileCallback.c
 **************************************/
#include <Xm/Xm.h>
#include <Xm/TextF.h>

extern  char* GetCompleteFileName(char *);

/* 
 * Replace the contents of the text field with the complete
 * name of a file that matches the current text.
 */
 
void CompleteFileCallback ( Widget    w, 
                            XtPointer clientData, 
                            XtPointer callData )
{
    XmTextVerifyCallbackStruct *cbs = 
                    ( XmTextVerifyCallbackStruct * ) callData;
    char completionChar = ( char ) clientData;

   /*
    * This function only works for modify verify callbacks
    * registered with XmTextField widgets!
    */

    if ( !( cbs->reason == XmCR_MODIFYING_TEXT_VALUE &&
            XmIsTextField ( w ) ) )
        return;

    if ( cbs && cbs->text && cbs->text->ptr && 
         cbs->text->ptr[0] == completionChar )
    {
       char *str = XmTextFieldGetString ( w );
       XmTextFieldSetString ( w, GetCompleteFileName ( str ) );
    }
}

char *GetCompleteFileName(char *name)
{

}

main()
{


}
