/********************************************************************
 *         This example code is from the book:
 *
 *           Motif Debuggin and Performance Tuning
 *            ISBN 0-13-147984-9
 *         by
 *           Douglas Young
 *           Prentice Hall, 1995
 *
 *         Copyright 1994 by Prentice Hall
 *         All Rights Reserved
 *
 *  Permission to use, copy, modify, and distribute this software for 
 *  any purpose except publication and without fee is hereby granted, provided 
 *  that the above copyright notice appear in all copies of the software.
 * *****************************************************************************/

/**************************************
 * CompleteFileCallback.c
 **************************************/
#include <Xm/Xm.h>
#include <Xm/TextF.h>
#include <Xm/Text.h>

extern char *GetCompleteFileName (char * );

/* 
 * Replace the contents of the text field with the complete
 * name of a file that matches the current text.
 */
 
void CompleteFileCallback ( Widget    w, 
                            XtPointer clientData, 
                            XtPointer callData )
{
    XmTextVerifyCallbackStruct *cbs = 
                    ( XmTextVerifyCallbackStruct * ) callData;
    char completionChar = ( char ) clientData;

   /*
    * This function only works with XmText 
    * and XmTextField widgets!
    */

    if ( !XmIsTextField ( w ) && !XmIsText ( w ) )
       return;

   /*
    * If the callback is a modifyverify callback, check 
    * that the entered character is the completion character.
    * If the callback is an activate callback, just expand.
    */

    if ( cbs->reason == XmCR_MODIFYING_TEXT_VALUE &&
         cbs && cbs->text && cbs->text->ptr && 
         cbs->text->ptr[0] == completionChar )
    {
       char *str = XmTextGetString ( w );
       XmTextSetString ( w, 
                         GetCompleteFileName ( str ) );
    }
    else if ( cbs->reason == XmCR_ACTIVATE ) 
    {
       char *str = XmTextGetString ( w );
       XmTextSetString ( w, GetCompleteFileName ( str ) );
    }
}

char *GetCompleteFileName(char *name)
{

}

main()
{

}
