/********************************************************************
 *         This example code is from the book:
 *
 *           Motif Debuggin and Performance Tuning
 *            ISBN 0-13-147984-9
 *         by
 *           Douglas Young
 *           Prentice Hall, 1995
 *
 *         Copyright 1994 by Prentice Hall
 *         All Rights Reserved
 *
 *  Permission to use, copy, modify, and distribute this software for 
 *  any purpose except publication and without fee is hereby granted, provided 
 *  that the above copyright notice appear in all copies of the software.
 * *****************************************************************************/

/**************************************
 * CompleteFileCallback.c
 **************************************/
#include <Xm/Xm.h>
#include <Xm/TextF.h>
#include <Xm/Text.h>
#include <stdlib.h>

extern char *GetCompleteFileName(char *);

/* 
 * Replace the contents of the text field with the complete
 * name of a file that matches the current text.
 */
 
void CompleteFileCallback ( Widget    w, 
                            XtPointer clientData, 
                            XtPointer callData )
{
    XmTextVerifyCallbackStruct *cbs = 
                    ( XmTextVerifyCallbackStruct * ) callData;
    char completionChar = ( char ) clientData;

#ifndef NDEBUG
   /*
    * This function only works for modify verify callbacks
    * registered with XmText and XmTextField widgets!
    */

    if ( cbs->reason != XmCR_MODIFYING_TEXT_VALUE ||
         ( !XmIsText ( w) && ! XmIsTextField ( w ) ) ||
         completionChar == NULL )
    {
        fprintf ( stderr, 
                  "Incorrect use of CompleteFileCallback" );
        abort();
    }
#endif

    if ( 
#ifndef NDEBUG
         cbs && cbs->text && 
#endif
         cbs->text->ptr && 
         cbs->text->ptr[0] == completionChar )
    {
       char *str = XmTextGetString ( w );
       XmTextSetString ( w, 
                         GetCompleteFileName ( str ) );
    }
}


char *GetCompleteFileName(char *name)
{

}

main()
{

}
