/********************************************************************
 *         This example code is from the book:
 *
 *           Motif Debuggin and Performance Tuning
 *            ISBN 0-13-147984-9
 *         by
 *           Douglas Young
 *           Prentice Hall, 1995
 *
 *         Copyright 1994 by Prentice Hall
 *         All Rights Reserved
 *
 *  Permission to use, copy, modify, and distribute this software for 
 *  any purpose except publication and without fee is hereby granted, provided 
 *  that the above copyright notice appear in all copies of the software.
 * *****************************************************************************/

/***********************************************************
 * CreateClock:  A convenience function to create a clock 
 *               that can be placed in any widget hierarchy.
 ***********************************************************/
#include <Xm/Xm.h>
#include <Xm/Label.h>
#include <time.h>
#include <stdio.h>

static void UpdateTime ( XtPointer    clientData,
                         XtIntervalId *id );

Widget CreateClock ( Widget parent )
{
    Widget face;

    face = XtCreateManagedWidget ( "face", xmLabelWidgetClass,
                                   parent, NULL, 0 );
    
    UpdateTime ( ( XtPointer ) face, NULL );
}

static void UpdateTime ( XtPointer clientData, XtIntervalId *id ) 
{
    Widget w =  ( Widget ) clientData;
    long   tloc, rounded_tloc, next_minute;
    char   buffer[100];

   /*
    * Get the system time.
    */
    
    time ( &tloc );
    
   /*
    * Convert the time to a string and display it,
    * after rounding it down to the last minute.
    */
    
    rounded_tloc = tloc / 60 * 60;
    
    sprintf ( buffer, "%s", ctime ( &rounded_tloc ) );

    XtVaSetValues ( w, 
                    XtVaTypedArg, XmNlabelString, XmRString,
                    buffer, strlen ( buffer ) + 1, NULL );
    
   /*
    * Adjust the time to reflect the time until 
    * the next round minute.
    */
    
    next_minute =  ( 60 - tloc % 60 ) * 1000;
    
   /*
    * Xt removes timeouts when they occur,
    * so re-register the function.
    */
    
    XtAppAddTimeOut ( XtWidgetToApplicationContext ( w ),
                      next_minute, UpdateTime,
                      ( XtPointer )  w );
}

