/********************************************************************
 *         This example code is from the book:
 *
 *           Motif Debuggin and Performance Tuning
 *            ISBN 0-13-147984-9
 *         by
 *           Douglas Young
 *           Prentice Hall, 1995
 *
 *         Copyright 1994 by Prentice Hall
 *         All Rights Reserved
 *
 *  Permission to use, copy, modify, and distribute this software for 
 *  any purpose except publication and without fee is hereby granted, provided 
 *  that the above copyright notice appear in all copies of the software.
 * *****************************************************************************/

#include <Xm/Xm.h>
#include <X11/cursorfont.h>

Boolean RemoveBusyCursor ( XtPointer clientData );
     
void DisplayBusyCursor ( Widget w ) 
{
    static cursor = NULL;

    if ( !cursor ) 
        cursor = XCreateFontCursor ( XtDisplay ( w ),
                                     XC_watch );  

    XDefineCursor ( XtDisplay ( w ), XtWindow ( w ),
                    cursor );

    XFlush ( XtDisplay ( w ) );

    XtAppAddWorkProc ( XtWidgetToApplicationContext ( w ), 
                       RemoveBusyCursor, ( XtPointer ) w );
}

#if 1
Boolean RemoveBusyCursor ( XtPointer clientData ) 
{
    Widget w = ( Widget ) clientData;

    XUndefineCursor ( XtDisplay ( w ), XtWindow ( w ) );

    return ( TRUE );
}
#else

Boolean RemoveBusyCursor ( XtPointer clientData ) 
{
    Widget w = ( Widget ) clientData;

    assert ( w && XtIsObject ( w ) );
    assert ( XtDisplay ( w ) );
    assert ( XtWindow ( w ) );

    XUndefineCursor ( XtDisplay ( w ), XtWindow ( w ) );

    return ( TRUE );
}


#endif

main()
{

}
