/********************************************************************
 *         This example code is from the book:
 *
 *           Motif Debuggin and Performance Tuning
 *            ISBN 0-13-147984-9
 *         by
 *           Douglas Young
 *           Prentice Hall, 1995
 *
 *         Copyright 1994 by Prentice Hall
 *         All Rights Reserved
 *
 *  Permission to use, copy, modify, and distribute this software for 
 *  any purpose except publication and without fee is hereby granted, provided 
 *  that the above copyright notice appear in all copies of the software.
 * *****************************************************************************/

/*******************************************************
 * buggydialog.c: Aattempt to post a dialog
 *******************************************************/
#include <Xm/Xm.h>
#include <Xm/DialogS.h>
#include <Xm/MessageB.h>

/***********************************************************
 * notbuggydialog.c:Straight-forward way to create and post
 *                   a simple dialog.
 ************************************************************/
#include <Xm/Xm.h>
#include <Xm/MessageB.h>

void PopupWarningCallback ( Widget    parent,
                            XtPointer clientData,
                            XtPointer callData )
{
    messagebox = XmCreateWarningDialog ( parent, "messagebox",
                                         NULL, 0 );
    XtVaSetValues ( messagebox,
                    XtVaTypedArg, XmNmessageString, XmRString,
                    "Watch Out", strlen ( "Watch Out") + 1,  
                    NULL );

    XtManageChild ( messagebox );
}

void PopupWarningCallback ( Widget    parent,
                            XtPointer clientData,
                            XtPointer callData )
{
    Arg      args[2];
    int      n;
    Widget   warn, dialog;
    XmString xmstr;

    n = 0;
    XtSetArg ( args[n], XmNtransientFor, parent ); n++;
    dialog = XtmCreateWidget ( "dialog",
                               xmDialogShellWidgetClass,
                               parent, args, n );

    xmstr = XmStringCreateLocalized ( "Watch out" );
    
    n = 0;
    XtSetArg ( args[n], XmNmessageString, xmstr ); n++;
    messagebox = XtCreateWidget ( "messagebox",
                                  xmMessageBoxWidgetClass,
                                  dialog, args, n );

    XmStringFree ( xmstr );

    XtPopup ( dialog, XtGrabExclusive );
    XtManageChild ( messagebox );
}


/***********************************************************
 * dialogposter.c: driver program to post a warning dialog
 ***********************************************************/
#include <Xm/Xm.h>
#include <Xm/PushB.h>

extern void PopupWarningCallback ( Widget, XtPointer,
                                   XtPointer );

void main ( int argc, char **argv )
{
    Widget       shell, button;
    XtAppContext app;

    shell = XtAppInitialize ( &app, "Dialogposter", NULL, 0, 
                              &argc, argv, NULL, NULL, 0 );

    button = XtCreateManagedWidget ( "popup", 
                                     xmPushButtonWidgetClass,
                                     shell, NULL, 0 );

    XtAddCallback ( button, XmNactivateCallback, 
                    PopupWarningCallback, NULL );

    XtRealizeWidget ( shell );
    XtAppMainLoop ( app );
}

