/********************************************************************
 *         This example code is from the book:
 *
 *           Motif Debuggin and Performance Tuning
 *            ISBN 0-13-147984-9
 *         by
 *           Douglas Young
 *           Prentice Hall, 1995
 *
 *         Copyright 1994 by Prentice Hall
 *         All Rights Reserved
 *
 *  Permission to use, copy, modify, and distribute this software for 
 *  any purpose except publication and without fee is hereby granted, provided 
 *  that the above copyright notice appear in all copies of the software.
 * *****************************************************************************/

/***************************************************
 * draw.c: Sample widget layout for a draw program
 ****************************************************/
#include <Xm/Xm.h>
#include <Xm/PushB.h>
#include <Xm/Label.h>
#include <Xm/DrawingA.h>
#include <Xm/Form.h>
#include <Xm/RowColumn.h>

Widget  CreateEditor ( const char *, Widget shell );
Widget  CreateFigures ( const char *, Widget shell );
Widget  CreateColors (const char *, Widget shell );
Widget  CreateCanvas ( const char *, Widget shell );

void main ( int argc, char **argv )
{
    Widget       shell;
    XtAppContext app;
  
    shell = XtAppInitialize ( &app, "Draw", NULL, 0, 
                              &argc, argv, NULL, NULL, 0 );

    CreateEditor ( "editor", shell );
  

    XtRealizeWidget ( shell );
    XtAppMainLoop ( app );
}

Widget CreateEditor ( const char * name, Widget shell )
{
    Widget form, figures, colors, canvas;

    form = XtCreateManagedWidget ( name, 
                                   xmFormWidgetClass, 
                                   shell, NULL, 0 );
  
    figures = CreateFigures ( "figures", form );
    colors = CreateColors ( "colors", form );
    canvas = CreateCanvas ( "canvas", form );

    XtVaSetValues ( colors, 
                    XmNtopAttachment,    XmATTACH_NONE,
                    XmNbottomAttachment, XmATTACH_FORM,
                    XmNleftAttachment,   XmATTACH_NONE,
                    XmNrightAttachment,  XmATTACH_FORM,
                    NULL );

    XtVaSetValues ( canvas,
                    XmNtopAttachment,    XmATTACH_FORM,
                    XmNrightAttachment,  XmATTACH_FORM,
                    XmNbottomAttachment, XmATTACH_WIDGET,
                    XmNbottomWidget,     colors,
                    XmNleftAttachment,   XmATTACH_WIDGET,
                    XmNleftWidget,       figures,
                    NULL );

    XtVaSetValues ( colors,
                    XmNtopAttachment,    XmATTACH_NONE,
                    XmNbottomAttachment, XmATTACH_FORM,
                    XmNleftAttachment,   XmATTACH_NONE,
                    XmNrightAttachment,  XmATTACH_FORM,
                    NULL );

  return ( form );
}

Widget CreateColors ( const char *name, Widget parent )
{
    Widget form, colorlabel, rowColumn, red, green, blue;
  
    form = XtCreateManagedWidget ( name, xmFormWidgetClass,
                                   parent, NULL, 0 );

    colorlabel = XtVaCreateManagedWidget ( "colorlabel",
                           xmLabelWidgetClass, form,
                           XmNtopAttachment,    XmATTACH_FORM,
                           XmNbottomAttachment, XmATTACH_NONE,
                           XmNleftAttachment,   XmATTACH_FORM,
                           XmNrightAttachment,  XmATTACH_FORM,
                           NULL );

    rowColumn = XtVaCreateManagedWidget ( "buttons",
                         xmRowColumnWidgetClass,form,
                         XmNorientation,      XmHORIZONTAL,
                         XmNtopAttachment,    XmATTACH_WIDGET,
                         XmNtopWidget,        colorlabel,
                         XmNbottomAttachment, XmATTACH_FORM,
                         XmNleftAttachment,   XmATTACH_FORM,
                         XmNrightAttachment,  XmATTACH_FORM,
                         NULL );

    red = XtCreateManagedWidget ( "red", 
                                  xmPushButtonWidgetClass,
                                  rowColumn, NULL, 0 );

    green = XtCreateManagedWidget ( "green",
                                    xmPushButtonWidgetClass,
                                    rowColumn, NULL, 0 );

    blue = XtCreateManagedWidget ( "blue",
                                   xmPushButtonWidgetClass,
                                   rowColumn, NULL, 0);
    return ( form );
}

Widget CreateCanvas(const char *name, Widget parent)
{
    Widget canvas;

    canvas = XtCreateManagedWidget ( name,
                                     xmDrawingAreaWidgetClass,
                                     parent, NULL, 0);
    return ( canvas );
}

Widget CreateFigures ( const char *name, Widget parent )
{
    Widget rowColumn, commandslabel, line, circle, square;
  
    rowColumn = XtCreateManagedWidget ( name,
                                       xmRowColumnWidgetClass,
                                       parent, NULL, 0);

    commandslabel = XtCreateManagedWidget ( "commandslabel",
                                           xmLabelWidgetClass,
                                           rowColumn, NULL,0 );
  
    line = XtCreateManagedWidget ( "line",
                                   xmPushButtonWidgetClass,
                                   rowColumn, NULL, 0 );
  
    circle = XtCreateManagedWidget ( "circle",
                                     xmPushButtonWidgetClass,
                                     rowColumn, NULL, 0 );

    square = XtCreateManagedWidget ( "square",
                                     xmPushButtonWidgetClass,
                                     rowColumn, NULL, 0 );

    return ( rowColumn );
}

#if 0
Widget CreateColors ( const char *name, Widget parent )
{
    Widget frame, colorlabel, rowColumn, red, green, blue;
  
    frame = XtCreateManagedWidget ( name,
                                    xmFrameWidgetClass,
                                    parent, NULL, 0 );

    colorlabel = 
          XtVaCreateManagedWidget ( "colorlabel",
                            xmLabelWidgetClass, frame,
                            XmNchildType, XmFRAME_TITLE_CHILD,
                            NULL );

    rowColumn = XtVaCreateManagedWidget ( "rowColumn",
                                 xmRowColumnWidgetClass,
                                 frame,
                                 XmNorientation, XmHORIZONTAL,
                                 NULL );
  
    red = XtCreateManagedWidget ( "red",
                                  xmPushButtonWidgetClass,
                                  rowColumn, NULL, 0 );

    green = XtCreateManagedWidget ( "green",
                                    xmPushButtonWidgetClass,
                                    rowColumn, NULL, 0 );


    blue = XtCreateManagedWidget ( "blue",
                                   xmPushButtonWidgetClass,
                                   rowColumn, NULL, 0 );
    return ( frame );
}

#endif

