/********************************************************************
 *         This example code is from the book:
 *
 *           Motif Debuggin and Performance Tuning
 *            ISBN 0-13-147984-9
 *         by
 *           Douglas Young
 *           Prentice Hall, 1995
 *
 *         Copyright 1994 by Prentice Hall
 *         All Rights Reserved
 *
 *  Permission to use, copy, modify, and distribute this software for 
 *  any purpose except publication and without fee is hereby granted, provided 
 *  that the above copyright notice appear in all copies of the software.
 * *****************************************************************************/

/**********************************************************
 * xclock2:  Use CreateClock() in a program that displays 
 *           a clock in a dialog.
 **********************************************************/
#include <Xm/Xm.h>
#include <Xm/PushB.h>
#include <Xm/MessageB.h>

extern Widget CreateClock ( Widget parent );
void ShowClock ( Widget, XtPointer, XtPointer );
void DestroyDialog ( Widget, XtPointer, XtPointer );

void main ( int argc, char ** argv )
{
    Widget       shell, button; 
    XtAppContext app; 

    shell = XtAppInitialize ( &app, "XClock", NULL, 0, 
                              &argc, argv, NULL, NULL, 0 );
   /*
    * Create a button that, when clicked, launches a dialog.
    */

    button =  XtCreateManagedWidget ( "show_clock", 
                                      xmPushButtonWidgetClass,
                                      shell, NULL, 0 );
    XtAddCallback ( button, XmNactivateCallback,
                    ShowClock, NULL );

    XtRealizeWidget ( shell );
    XtAppMainLoop ( app );
}

void ShowClock ( Widget    w,
                 XtPointer callData,
                 XtPointer clientData )
{
    Widget dialog, child;

   /*
    * Create a dialog and remove current work area child.
    */

    dialog = XmCreateInformationDialog ( w, "clock",
                                         NULL, 0 );
    child = XmMessageBoxGetChild ( dialog,
                                   XmDIALOG_MESSAGE_LABEL );
    XtUnmanageChild ( child );

   /*
    * Add the clock to the dialog.
    */

    CreateClock ( dialog );

   /*
    * Destroy the dialog when the user dismisses it.
    */

    XtAddCallback ( dialog, XmNokCallback,
                    DestroyDialog, NULL );

    XtManageChild(dialog);
}

void DestroyDialog ( Widget    w,
                     XtPointer callData, 
                     XtPointer clientData )
{
    XtDestroyWidget ( w );
}

