/********************************************************************
 *         This example code is from the book:
 *
 *           Motif Debuggin and Performance Tuning
 *            ISBN 0-13-147984-9
 *         by
 *           Douglas Young
 *           Prentice Hall, 1995
 *
 *         Copyright 1994 by Prentice Hall
 *         All Rights Reserved
 *
 *  Permission to use, copy, modify, and distribute this software for 
 *  any purpose except publication and without fee is hereby granted, provided 
 *  that the above copyright notice appear in all copies of the software.
 * *****************************************************************************/

/******************************************************
 * xlogobug.c: Mis-architected program
 ******************************************************/
#include <Xm/Xm.h>
#include <Xm/DrawingA.h>

GC  gc;

void ExposeCallback ( Widget   w, 
                      XtPointer clientData,
                      XtPointer callData )
{
    int width, height;

    XtVaGetValues ( w,
                    XmNwidth,      &width,
                    XmNheight,     &height,
                    NULL );

    XDrawLine ( XtDisplay ( w ), XtWindow ( w ), gc,
                0, 0, width, height);  

    XDrawLine ( XtDisplay ( w ), XtWindow ( w ), gc,
                width, 0, 0, height);  
}

void WindowMapped ( Widget w, 
                    XtPointer clientData, XEvent *event, Boolean *flag )
{
    Widget canvas = ( Widget ) clientData;
    XGCValues    values;

    if ( event->type == MapNotify )
    {
        /*
         * Get the colors to use in a graphics context.
         */

         XtVaGetValues ( canvas,
                         XmNforeground, &values.foreground,
                         NULL );

         gc = XtGetGC ( canvas, GCForeground, &values );
    }
}

void main ( int argc, char **argv )
{
    Widget       shell, canvas; 
    XtAppContext app; 

    shell = XtAppInitialize ( &app, "Xlogobug", NULL, 0, 
                              &argc, argv, NULL, NULL, 0 );

   /*
    * Create a drawing area widget in which to display
    * a pair of lines that form an X.
    */

    canvas = XtCreateManagedWidget ( "canvas", 
                                     xmDrawingAreaWidgetClass,
                                     shell, NULL, 0 );
   /*
    * Add a callback to be invoked when the contents of 
    * the canvas widget should be drawn.
    */

    XtAddCallback ( canvas, XmNexposeCallback,
                    ExposeCallback, NULL );
   /*
    * Add an event handler to create the GC when the window
    * is first mapped.
    */


    XtAddEventHandler ( canvas, StructureNotifyMask, 0,
                        WindowMapped, ( XtPointer ) canvas );

    XtRealizeWidget ( shell );

   /*
    * Call XmUpdateDisplay() to force the window to be drawn
    */

    XmUpdateDisplay ( shell );
    XtAppMainLoop ( app );
}

