/********************************************************************
 *         This example code is from the book:
 *
 *           Motif Debuggin and Performance Tuning
 *            ISBN 0-13-147984-9
 *         by
 *           Douglas Young
 *           Prentice Hall, 1995
 *
 *         Copyright 1994 by Prentice Hall
 *         All Rights Reserved
 *
 *  Permission to use, copy, modify, and distribute this software for 
 *  any purpose except publication and without fee is hereby granted, provided 
 *  that the above copyright notice appear in all copies of the software.
 * *****************************************************************************/

/************************************************
 * hello.c: Display "Hello World" in a window
 ************************************************/
#include <Xm/Xm.h>        
#include <Xm/Label.h>     

extern XtEventHandler _XEditResCheckMessages;

void main ( int argc, char **argv )
{
    Widget       shell, msg;
    XtAppContext app; 
    XmString     xmstr;

   /*
    * Initialize Xt.
    */

    shell = XtAppInitialize ( &app, "Hello", NULL, 0, 
                              &argc, argv, NULL, NULL, 0 );

   /*
    * Install event handler for editres protocol.
    */

    XtAddEventHandler ( shell, ( EventMask ) 0, TRUE,
                        _XEditResCheckMessages, NULL);

   /* Create a compound string */

    xmstr = XmStringCreateSimple ( "Hello World" );

   /*
    * Create a Motif XmLabel widget to display the string.
    */

    msg = XtVaCreateManagedWidget ( "hello", 
                                    xmLabelWidgetClass, shell,
                                    XmNlabelString,     xmstr,
                                    NULL );

    XmStringFree ( xmstr );  /* Free the compound string. */

   /*
    * Realize the shell and enter an event loop.
    */

    XtRealizeWidget ( shell );
    XtAppMainLoop ( app );
}

