/********************************************************************
 *         This example code is from the book:
 *
 *           Motif Debuggin and Performance Tuning
 *            ISBN 0-13-147984-9
 *         by
 *           Douglas Young
 *           Prentice Hall, 1995
 *
 *         Copyright 1994 by Prentice Hall
 *         All Rights Reserved
 *
 *  Permission to use, copy, modify, and distribute this software for 
 *  any purpose except publication and without fee is hereby granted, provided 
 *  that the above copyright notice appear in all copies of the software.
 * *****************************************************************************/

/************************************************
  * label.c: Display a label in a window
  ************************************************/
 #include <Xm/Xm.h>        
 #include <Xm/Label.h>
 #include <stdio.h>     
 #include "wlint.h"

 void main ( int argc, char **argv )
{
    Widget       shell, msg;
    XtAppContext app; 

    shell = XtAppInitialize ( &app, "Label", NULL, 0, 
                              &argc, argv, NULL, NULL, 0 );

    msg = XtCreateManagedWidget ( "msg", 
                                  xmLabelWidgetClass, shell, 
                                  NULL, 0 );
   /*
    * Deliberately overwrite the widget so we can test 
    * the WL function.
    */

    sprintf ( ( char * ) msg, "A silly code overwrite" );
    WLRunTests ( shell, "Before Main Loop" );    
    XtRealizeWidget ( shell );

    XtAppMainLoop ( app );
}

