/********************************************************************
 *         This example code is from the book:
 *
 *           Motif Debuggin and Performance Tuning
 *            ISBN 0-13-147984-9
 *         by
 *           Douglas Young
 *           Prentice Hall, 1995
 *
 *         Copyright 1994 by Prentice Hall
 *         All Rights Reserved
 *
 *  Permission to use, copy, modify, and distribute this software for 
 *  any purpose except publication and without fee is hereby granted, provided 
 *  that the above copyright notice appear in all copies of the software.
 * *****************************************************************************/

/*****************************************************
 * popupmenu.c: Demonstrate how to create a popup.
 *****************************************************/
#include <Xm/Xm.h>
#include <Xm/Label.h>
#include <Xm/RowColumn.h>
#include <Xm/PushB.h>
#include <Xm/Separator.h>
#include <Xm/BulletinB.h>
#include <Xm/CascadeB.h>
#include <stdio.h>

static void PostMenu ( Widget    w, 
                       XtPointer clientData,
                       XEvent   *event, 
                       Boolean  *flag );
void CreatePopupMenu ( Widget parent ); 

void main ( int argc, char ** argv ) 
{
    Widget       shell, bboard;
    XtAppContext app;

   /*
    * Initialize Xt and create a widget.
    */
    
    shell = XtAppInitialize (  &app, "Popupmenu", NULL, 0, 
                               &argc, argv, NULL, NULL, 0 );

    bboard = 
           XtCreateManagedWidget ( "bboard", 
                                   xmBulletinBoardWidgetClass,
                                   shell, NULL, 0 );
   /*
    * Create a popup menu, as a child of the bulletin board.
    */

    CreatePopupMenu ( bboard );

    XtRealizeWidget ( shell );
    XtAppMainLoop ( app );
}

void CreatePopupMenu ( Widget parent ) 
{
    Widget menu, button1, button2, button3;

   /*
    * Create a popup menu. Add an event handler
    * to the given widget to pop up the menu when
    * a mouse button is pressed.
    */

    menu = XmCreatePopupMenu ( parent, "menu", NULL, 0 );

    XtAddEventHandler ( parent, ButtonPressMask, FALSE,
                        PostMenu, menu );

   /*
    * Add buttons to the pane.
    */

    button1 = XtCreateManagedWidget ( "Item1",
                                      xmPushButtonWidgetClass,
                                      menu, NULL, 0 );

    button2 = XtCreateManagedWidget ( "Item2",
                                      xmPushButtonWidgetClass,
                                      menu, NULL, 0 );
}

static void PostMenu (  Widget    w, 
                        XtPointer clientData, 
                        XEvent    *event, 
                        Boolean   *flag ) 
{
    Widget  menu = ( Widget )  clientData;

    
    if ( event->xbutton.button == Button3 )
    {
       /*
        * Position the menu over the pointer and post.
        */
        
        XmMenuPosition ( menu, 
                        ( XButtonPressedEvent * ) event );
        XtManageChild ( menu );
    }
}

