/********************************************************************
 *         This example code is from the book:
 *
 *           Motif Debuggin and Performance Tuning
 *            ISBN 0-13-147984-9
 *         by
 *           Douglas Young
 *           Prentice Hall, 1995
 *
 *         Copyright 1994 by Prentice Hall
 *         All Rights Reserved
 *
 *  Permission to use, copy, modify, and distribute this software for 
 *  any purpose except publication and without fee is hereby granted, provided 
 *  that the above copyright notice appear in all copies of the software.
 * *****************************************************************************/

/****************************************************
 * register.c: Register all test functions with WL
 ****************************************************/
#include "wlintP.h"
extern void ValidWidgetTest ( Widget );
extern void UnmanagedTest ( Widget );
extern void ClassNameTest ( Widget );
extern void CapitalizationTest ( Widget );

void WLRegisterTests ( void )
{
   /* Add new tests here by calling WLAddTest() */

    WLAddTest ( "Testing for Invalid and destroyed widgets ",
                ALL, ValidWidgeTest }
    WLAddTest ( "Unmanaged Widget Test ",
                ALL, UnmanagedTest );    
    WLAddTest ( "Name/class name mismatch",
                JUSTONCE, ClassNameTest );                    
    WLAddTest ( "Checking classname conventions",
                JUSTONCE, CapitalizationTest );
}

