/********************************************************************
 *         This example code is from the book:
 *
 *           Motif Debuggin and Performance Tuning
 *            ISBN 0-13-147984-9
 *         by
 *           Douglas Young
 *           Prentice Hall, 1995
 *
 *         Copyright 1994 by Prentice Hall
 *         All Rights Reserved
 *
 *  Permission to use, copy, modify, and distribute this software for 
 *  any purpose except publication and without fee is hereby granted, provided 
 *  that the above copyright notice appear in all copies of the software.
 * *****************************************************************************/

/***********************************************************
 * busy.c: Display a dialog while the program is busy
 ***********************************************************/
#include <Xm/Xm.h>
#include <Xm/MessageB.h>
#include <Xm/PushB.h>
#include <stdlib.h>

void BusyCallback ( Widget    w,
                    XtPointer clientData,
                    XtPointer callData );

void main ( int argc, char **argv )
{
    Widget       shell, button;
    XtAppContext app;

    shell = XtAppInitialize ( &app, "Busy", NULL, 0, 
                              &argc, argv, NULL, NULL, 0 );

   /* 
    * Create a button and add a callback to start the task 
    */

    button = XtCreateManagedWidget ( "Start", 
                                     xmPushButtonWidgetClass,
                                     shell, NULL, 0 );

    XtAddCallback ( button, XmNactivateCallback, 
                    BusyCallback, NULL );

    XtRealizeWidget ( shell );
    XtAppMainLoop ( app );
}

#if 0

#define BUSYMSG "Busy, Please wait"

void BusyCallback ( Widget    w,
                    XtPointer clientData,
                    XtPointer callData )
{
    static Widget dialog = NULL;

    if ( !dialog )
    {
       /*
        * Create the dialog if it doesnt already exist.
        */

        dialog = XmCreateWorkingDialog ( w, "dialog",
                                         NULL, 0 );

        XtVaSetValues ( dialog, 
                        XtVaTypedArg, XmNmessageString, 
                        XmRString, 
                        BUSYMSG, strlen ( BUSYMSG )+1, 
                        NULL );
    }

   /*
    * Display the dialog
    */

    XtManageChild ( dialog );

   /* 
    * Simulate a lengthy task.
    */

    sleep ( 10 );

   /*
    * When the task is complete, remove the dialog
    */

    XtUnmanageChild ( dialog );
}

#else

#define BUSYMSG "Busy, Please wait"
                                
void BusyCallback ( Widget    w,
                    XtPointer clientData,
                    XtPointer callData )
{
    static Widget dialog = NULL;

    if ( !dialog )
    {
       /*
        * Create the dialog if it doesnt already exist.
        */

        dialog = XmCreateWorkingDialog ( w, "dialog", 
                                         NULL, 0 );

        XtVaSetValues ( dialog, 
                        XtVaTypedArg, XmNmessageString, 
                        XmRString, 
                        BUSYMSG, strlen ( BUSYMSG ) + 1, 
                        NULL );
    }

   /*
    * Display the dialog, flushing the request queue
    */

    XtManageChild ( dialog );
    XFlush ( XtDisplay ( dialog ) );

   /* 
    * Simulate a lengthy task.
    */

    sleep ( 10 );

   /*
    * When the task is complete, remove the dialog
    */

    XtUnmanageChild ( dialog );
}

#endif
