/********************************************************************
 *         This example code is from the book:
 *
 *           Motif Debuggin and Performance Tuning
 *            ISBN 0-13-147984-9
 *         by
 *           Douglas Young
 *           Prentice Hall, 1995
 *
 *         Copyright 1994 by Prentice Hall
 *         All Rights Reserved
 *
 *  Permission to use, copy, modify, and distribute this software for 
 *  any purpose except publication and without fee is hereby granted, provided 
 *  that the above copyright notice appear in all copies of the software.
 * *****************************************************************************/

/********************************************************
  * doubledestroy.c: Show results of destroying a 
  *                   widget twice.
  *****************************************************/
#include <Xm/Xm.h> 
#include <Xm/PushB.h>
#include <stdio.h>

void main ( int argc, char **argv )
{
     Widget       shell, button; 
     XtAppContext app;
   
     shell = XtAppInitialize ( &app, "Doubledestroy", NULL, 0,
                               &argc, argv, NULL, NULL, 0 );

     button = XtCreateManagedWidget ( "button", 
                                      xmPushButtonWidgetClass,
                                      shell, NULL, 0 );
    /*
     * Destroy the button once 
     */

     XtDestroyWidget ( button );

    /*
     * Bug! Destroy the button widget again!
     */

     XtDestroyWidget ( button );

     XtRealizeWidget ( shell );
     XtAppMainLoop ( app );
}

