/********************************************************************
 *         This example code is from the book:
 *
 *           Motif Debuggin and Performance Tuning
 *            ISBN 0-13-147984-9
 *         by
 *           Douglas Young
 *           Prentice Hall, 1995
 *
 *         Copyright 1994 by Prentice Hall
 *         All Rights Reserved
 *
 *  Permission to use, copy, modify, and distribute this software for 
 *  any purpose except publication and without fee is hereby granted, provided 
 *  that the above copyright notice appear in all copies of the software.
 * *****************************************************************************/

/************************************************************
 * drawline.c: Demonstrate a bug involving Xlib and widgets
 ***********************************************************/
#include <Xm/Xm.h> 
#include <Xm/DrawingA.h> 

void main ( int argc, char **argv )
{
    Widget       shell, canvas;
    XtAppContext app; 
    GC           gc;
 
    shell = XtAppInitialize ( &app, "Drawline", NULL, 0, 
                              &argc, argv, NULL, NULL, 0 );

    canvas = XtCreateManagedWidget ( "canvas",
                                     xmDrawingAreaWidgetClass,
                                     shell, NULL, 0 );

    gc = XtGetGC ( canvas, NULL, 0 );

   /*
    * BUG. Try to draw to an unrealized widget. 
    */

    XDrawLine( XtDisplay ( canvas ), XtWindow ( canvas ),
               gc, 0, 0, 20, 20 );

    XtRealizeWidget ( shell );
    XtAppMainLoop ( app );
}

