/********************************************************************
 *         This example code is from the book:
 *
 *           Motif Debuggin and Performance Tuning
 *            ISBN 0-13-147984-9
 *         by
 *           Douglas Young
 *           Prentice Hall, 1995
 *
 *         Copyright 1994 by Prentice Hall
 *         All Rights Reserved
 *
 *  Permission to use, copy, modify, and distribute this software for 
 *  any purpose except publication and without fee is hereby granted, provided 
 *  that the above copyright notice appear in all copies of the software.
 * *****************************************************************************/

/************************************
 * SetupErrorHandlers.c
 ************************************/
#include <X11/Intrinsic.h>
#include <stdio.h>
#include <string.h>

/*
 * The following error handlers abort when called
 * to produce a core dump that can be used for debugging
 */

static void MyXtErrorHandler ( String msg )
{
   fprintf ( stderr, msg );
   abort();
}
static int MyXIOErrorHandler ( Display *dpy )
{
   fprintf ( stderr, "X IO Error\n" );
   abort();
}

static int MyXErrorHandler ( Display *dpy, XErrorEvent *ev )
{
   fprintf ( stderr, "X error\n" );
   abort();
}

/*
 * Install the above error handlers if the "abortOnErrors" 
 * resource is true.
 */

void SetupErrorHandlers ( Widget w, char *name )
{
    Display *display = XtDisplay ( w );
    XtAppContext appContext = 
                          XtWidgetToApplicationContext ( w );

    char *opt = XGetDefault ( display, name,
                              "abortOnErrors" );

    if ( opt && !strcasecmp ( opt, "true" ) )
    {
       XtAppSetWarningHandler ( appContext, MyXtErrorHandler );
       XtAppSetErrorHandler ( appContext, MyXtErrorHandler );
       XSetErrorHandler ( MyXErrorHandler );
       XSetIOErrorHandler ( MyXIOErrorHandler );
    }
}


main()
{


}

