/********************************************************************
 *         This example code is from the book:
 *
 *           Motif Debuggin and Performance Tuning
 *            ISBN 0-13-147984-9
 *         by
 *           Douglas Young
 *           Prentice Hall, 1995
 *
 *         Copyright 1994 by Prentice Hall
 *         All Rights Reserved
 *
 *  Permission to use, copy, modify, and distribute this software for 
 *  any purpose except publication and without fee is hereby granted, provided 
 *  that the above copyright notice appear in all copies of the software.
 * *****************************************************************************/

/********************************************************
 * vararg.c: Demonstrate the error resulting from a 
 *           non-terminated vararg function.
 *********************************************************/
#include <Xm/Xm.h>        
#include <Xm/Label.h>
#include <Xm/PushB.h>
#include <Xm/RowColumn.h>
#include <stdio.h>     


void Callback ( Widget    w, 
                XtPointer clientData,
                XtPointer callData)
{
    Widget   label = ( Widget ) clientData;
    XmString xmstr;
    static   int count = 0;
    char     buf[100];

    sprintf ( buf, "Called %d times", count++ );

    xmstr = XmStringCreateLocalized ( buf );

    XtVaSetValues ( label, XmNlabelString, xmstr );

    XmStringFree ( xmstr );
}

 void main ( int argc, char **argv )
{
    Widget       shell, label, button, rc;
    XtAppContext app; 
    
    shell = XtAppInitialize ( &app, "Varargbug", NULL, 0, 
                              &argc, argv, NULL, NULL, 0 );

    rc = XtCreateManagedWidget ( "rc", 
                                 xmRowColumnWidgetClass,
                                 shell, NULL, 0 );
    
    label = XtCreateManagedWidget ( "label", 
                                    xmLabelWidgetClass,
                                    rc, NULL, 0 );

    button = XtCreateManagedWidget ( "button",
                                     xmPushButtonWidgetClass,
                                     rc, NULL, 0 );

    XtAddCallback ( button, XmNactivateCallback,
                    Callback, label );
    
    XtRealizeWidget ( shell );
    XtAppMainLoop ( app );
}

