/********************************************************************
 *         This example code is from the book:
 *
 *           Motif Debuggin and Performance Tuning
 *            ISBN 0-13-147984-9
 *         by
 *           Douglas Young
 *           Prentice Hall, 1995
 *
 *         Copyright 1994 by Prentice Hall
 *         All Rights Reserved
 *
 *  Permission to use, copy, modify, and distribute this software for 
 *  any purpose except publication and without fee is hereby granted, provided 
 *  that the above copyright notice appear in all copies of the software.
 * *****************************************************************************/

#include <Xm/Xm.h>
#include <Xm/Label.h>

void main ( int argc, char **argv )
{

    Widget       shell, msg;
    XtAppContext app; 
    XmString     xmstr;
    int n;
    Arg *args = (ArgList) malloc(2 * sizeof(Arg));    

    shell = XtAppInitialize ( &app, "Hello", NULL, 0, 
                              &argc, argv, NULL, NULL, 0 );

    xmstr = XmStringCreateSimple ( "Hello World" );

    n = 0;
    XtSetArg(args[n], XmNlabelString, xmstr); n++;
    XtSetArg(args[n], XmNwidth, 50); n++;
    XtSetArg(args[n], XmNheight, 50); n++;
    msg = XtCreateManagedWidget ( "hello", 
				  xmLabelWidgetClass, shell,
				  args, n );

    XtRealizeWidget ( shell );
    XtAppMainLoop ( app );
}

