/********************************************************************
 *         This example code is from the book:
 *
 *           Motif Debuggin and Performance Tuning
 *            ISBN 0-13-147984-9
 *         by
 *           Douglas Young
 *           Prentice Hall, 1995
 *
 *         Copyright 1994 by Prentice Hall
 *         All Rights Reserved
 *
 *  Permission to use, copy, modify, and distribute this software for 
 *  any purpose except publication and without fee is hereby granted, provided 
 *  that the above copyright notice appear in all copies of the software.
 * *****************************************************************************/

#include "stdio.h"
#include <Xm/DrawnB.h>

void Redisplay(Widget, XtPointer, XtPointer);

main(int argc, char *argv[])
{
   Widget shell, canvas;
   XtAppContext app;

   shell = XtVaAppInitialize(&app, "Demos", NULL, 0, &argc, argv,
                                NULL, NULL);
   canvas = XtVaCreateManagedWidget("canvas", xmDrawnButtonWidgetClass,
				shell,
                                XmNheight, 100,
                                XmNwidth, 100,
                                NULL);

   XtAddCallback(canvas, XmNexposeCallback,
		 Redisplay, NULL);
   
   XtRealizeWidget(shell);
   XtAppMainLoop(app);
}

void Redisplay(Widget canvas, XtPointer clientData, XtPointer callData )
{
  XmDrawingAreaCallbackStruct *cbs = (XmDrawingAreaCallbackStruct *)callData;
  XmString xmstr;
  XmFontList fontlist;
  GC gc;

  gc = XtAllocateGC(canvas, 0, 0, NULL,
		    GCFont | GCBackground | GCForeground, 0);
  
  XtVaGetValues(canvas, XmNfontList, &fontlist, NULL);
  
  xmstr = XmStringCreateLtoR("A String",
			     XmSTRING_DEFAULT_CHARSET);

  
  XmStringDraw(XtDisplay(canvas), XtWindow(canvas),
	       fontlist,
	       xmstr, gc, 1, 1, 30,
	       XmALIGNMENT_BEGINNING,
	       XmSTRING_DIRECTION_L_TO_R, NULL);
}
