/********************************************************************
 *         This example code is from the book:
 *
 *           Motif Debuggin and Performance Tuning
 *            ISBN 0-13-147984-9
 *         by
 *           Douglas Young
 *           Prentice Hall, 1995
 *
 *         Copyright 1994 by Prentice Hall
 *         All Rights Reserved
 *
 *  Permission to use, copy, modify, and distribute this software for 
 *  any purpose except publication and without fee is hereby granted, provided 
 *  that the above copyright notice appear in all copies of the software.
 * *****************************************************************************/

#include <stdio.h>
#include <Xm/Xm.h>
#include <Xm/MainW.h>
#include <Xm/Label.h>
#include <Xm/DrawingA.h>

void main ( int argc, char **argv )
{
    Widget        shell, tree, msg, mainw;
    XtAppContext  app;
    int i;
	
    shell = XtAppInitialize ( &app, "Sort", NULL, 0, 
                              &argc, argv, NULL, NULL, 0 );

    mainw = XtCreateManagedWidget( "mainWindow", xmMainWindowWidgetClass,
				   shell,
				   NULL, 0);

    msg = XtCreateManagedWidget( "message", xmLabelWidgetClass, mainw,
				 NULL, 0);				   
 
    tree = XmCreateDrawingArea ( mainw, "canvas", NULL, 0 );
    XtManageChild ( tree );

    XtVaSetValues(mainw,
		  XmNworkWindow, tree,
		  XmNmessageWindow, msg,
		  NULL);

    XtRealizeWidget ( shell ); 
    XmUpdateDisplay(shell);

    for(i = 0; i < 10; i++)
    {
	char buf[100];
	XmString xmstr;

	sleep(2);
	
	sprintf(buf, "%d%% Done", (i +1)* 10);
	xmstr = XmStringCreateLocalized(buf);
	XtVaSetValues(msg, XmNlabelString, xmstr, NULL);
	XmStringFree(buf);
	XmUpdateDisplay(shell);	
    }

    XtAppMainLoop ( app );
}

