/********************************************************************
 *         This example code is from the book:
 *
 *           Motif Debuggin and Performance Tuning
 *            ISBN 0-13-147984-9
 *         by
 *           Douglas Young
 *           Prentice Hall, 1995
 *
 *         Copyright 1994 by Prentice Hall
 *         All Rights Reserved
 *
 *  Permission to use, copy, modify, and distribute this software for 
 *  any purpose except publication and without fee is hereby granted, provided 
 *  that the above copyright notice appear in all copies of the software.
 * *****************************************************************************/

/*************************************************
 * labels.c: Three labels in a form
 *************************************************/
#include <Xm/Xm.h>
#include <Xm/Form.h>
#include <Xm/Label.h>

void main ( int argc, char ** argv ) 
{
    Widget       shell, form, label1, label2, label3;
    XtAppContext app;
    int          i;

    shell = XtAppInitialize ( &app, "Labels",  NULL, 0, 
                              &argc, argv, NULL, NULL, 0 );

    /*
     * Create a form to hold the other two widgets
     */

    form = XtCreateManagedWidget ( "form", 
                                   xmFormWidgetClass, 
                                   shell, NULL, 0 );
    label1 = 
        XtVaCreateManagedWidget ( "label1", xmLabelWidgetClass,
                      form,
                      XmNleftAttachment,  XmATTACH_FORM,				
                      XmNrightAttachment, XmATTACH_NONE,
                      NULL );

    label2 = 
        XtVaCreateManagedWidget ( "label2", xmLabelWidgetClass,
                     form,
                     XmNleftWidget,     label1,
                     XmNleftAttachment, XmATTACH_WIDGET,
                     XmNrightAttachment,XmATTACH_NONE,
                     NULL );

    label3 = 
        XtVaCreateManagedWidget ( "label3", xmLabelWidgetClass,
                     form,
                     XmNleftWidget,      label2,
                     XmNleftAttachment,  XmATTACH_WIDGET,
                     XmNrightAttachment, XmATTACH_NONE,
                     NULL );    

    XtRealizeWidget ( shell );

    XtAppMainLoop ( app );
}

