/********************************************************************
 *         This example code is from the book:
 *
 *           Motif Debuggin and Performance Tuning
 *            ISBN 0-13-147984-9
 *         by
 *           Douglas Young
 *           Prentice Hall, 1995
 *
 *         Copyright 1994 by Prentice Hall
 *         All Rights Reserved
 *
 *  Permission to use, copy, modify, and distribute this software for 
 *  any purpose except publication and without fee is hereby granted, provided 
 *  that the above copyright notice appear in all copies of the software.
 * *****************************************************************************/

/*************************************************
 * scale.c: Create a labeled scale in a form
 *************************************************/
#include <Xm/Xm.h>
#include <Xm/Form.h>
#include <Xm/Label.h>
#include <Xm/Scale.h>

extern void DumpResources ( Display *dpy );
extern XtEventHandler _XEditResCheckMessages;

void main ( int argc, char ** argv ) 
{
    Widget       shell, form, label, scale;
    XtAppContext app;
    int          i;

    shell = XtAppInitialize ( &app, "Scale",  NULL, 0, 
                              &argc, argv, NULL, NULL, 0 );

/*    XtAddEventHandler ( shell, ( EventMask ) 0, TRUE,
                        _XEditResCheckMessages, NULL );
			*/			

    form = XtCreateManagedWidget ( "form", xmFormWidgetClass, 
                                   shell, NULL, 0 );
   /*
    * The label goes to the left.
    */

   label = 
        XtVaCreateManagedWidget ( "label", xmLabelWidgetClass,
                          form,
                          XmNtopAttachment,    XmATTACH_FORM,
                          XmNbottomAttachment, XmATTACH_FORM,
                          XmNleftAttachment,   XmATTACH_FORM,
                          XmNrightAttachment,  XmATTACH_NONE,
                          NULL);
   /*
    * The scale is attached to the right side of the label.
    */

    scale = 
        XtVaCreateManagedWidget ( "scale", xmScaleWidgetClass,
                         form,
                         XmNtopAttachment,    XmATTACH_FORM,
                         XmNbottomAttachment, XmATTACH_FORM,
                         XmNleftAttachment,   XmATTACH_WIDGET,
                         XmNleftWidget,       label,
                         XmNrightAttachment,  XmATTACH_FORM,
                         NULL );

    DumpResources ( XtDisplay ( shell ) );
    XtRealizeWidget ( shell );
    XtAppMainLoop ( app );
}

