/********************************************************************
 *         This example code is from the book:
 *
 *           Motif Debuggin and Performance Tuning
 *            ISBN 0-13-147984-9
 *         by
 *           Douglas Young
 *           Prentice Hall, 1995
 *
 *         Copyright 1994 by Prentice Hall
 *         All Rights Reserved
 *
 *  Permission to use, copy, modify, and distribute this software for 
 *  any purpose except publication and without fee is hereby granted, provided 
 *  that the above copyright notice appear in all copies of the software.
 * *****************************************************************************/

/*********************************************************
 * maptime.c: Report the time required to start an X 
 *            application and map the first window. 
 ***********************************************************/
#include <sys/types.h>
#include <sys/time.h>
#include <X11/Xlib.h>
#include <unistd.h>
#include <stdio.h>

void main ( int argc, char **argv )
{
    Display *dpy;
    XEvent   event;
    struct   timeval start, finish;
    int      msec;

   /*
    * Open default display.
    */

    dpy = XOpenDisplay ( NULL );

   /*
    * Request SubstructureNotify events for the root window.
    * This will include MapNotify events for all children.
    */

    XSelectInput ( dpy, DefaultRootWindow ( dpy ),
                   SubstructureNotifyMask );
   /*
    * Get the starting time.
    */

    gettimeofday ( &start, NULL );

   /*
    * Launch the process by forking and calling execvp().
    */

    if ( fork() == 0 ) 
    {
       /*
        * In child process.
        */

        close ( ConnectionNumber ( dpy ) );
        execvp ( argv[1], argv + 1 );
        exit ( -1 );
    }

   /*
    * In parent process, watch for a MapNotify event from a 
    * child of the root window. Note that we could get the
    * wrong child, as there is no way to be sure the window
    * is created by the process just launched. But normally,
    * in a controlled test, the next window to be mapped would
    * the window we are waiting for.
    */

    for ( ; ; )
    {
        XNextEvent ( dpy, &event );

        if ( event.type == MapNotify )
        {
           /*
            * Get the current time, and compute the difference
            * between the time measured before the process
            * was started.
            */

            gettimeofday ( &finish, NULL );
            msec = finish.tv_sec * 1000 + finish.tv_usec / 
                                                         1000;
            msec -= start.tv_sec * 1000 + start.tv_usec / 
                                                         1000;

           /*
            * Report time and exit.
            */

            printf ( "Startup time: %d milliseconds\n",
                      msec );
            exit ( 0 );
        }
    }
}

