/********************************************************************
 *         This example code is from the book:
 *
 *           Motif Debuggin and Performance Tuning
 *            ISBN 0-13-147984-9
 *         by
 *           Douglas Young
 *           Prentice Hall, 1995
 *
 *         Copyright 1994 by Prentice Hall
 *         All Rights Reserved
 *
 *  Permission to use, copy, modify, and distribute this software for 
 *  any purpose except publication and without fee is hereby granted, provided 
 *  that the above copyright notice appear in all copies of the software.
 * *****************************************************************************/

/**********************************************************
 * fileviewer.c: Display a file with line numbers
 **********************************************************/
#include <stdio.h>
#include <Xm/Xm.h>
#include <Xm/Text.h>
#include <Xm/MainW.h>
#include "TimerTools.h"
#include <sys/types.h>
#include <sys/stat.h>

void main ( int argc, char ** argv ) 
{
    XtAppContext app;
    Widget       menu, text, shell , mainwindow;
    int          i, file_length;
    struct stat statbuf; 
    char        *file_string;
    FILE        *fp = NULL;

    ReportTime ( "Starting", FALSE );
 
    shell = XtAppInitialize ( &app, "Fileviewer", NULL, 0, 
                              &argc, argv, NULL, NULL, 0 );

    mainwindow = 
           XtVaCreateManagedWidget ( "mainwindow", 
                                     xmMainWindowWidgetClass,
                                     shell, NULL, 0 );

    text = XmCreateScrolledText ( mainwindow, "text", 
                                  NULL, 0 );
    XtManageChild ( text );  

    XtVaSetValues ( text,
                    XmNcolumns, 80,
                    XmNrows, 24,
                    XmNeditMode, XmMULTI_LINE_EDIT,
                    XmNcursorPositionVisible, FALSE,
                    NULL );
  
    XtVaSetValues ( mainwindow,
                    XmNworkWindow, XtParent(text),
                    NULL );

    if ( argc > 1 && 
         ( fp = fopen ( argv[1], "r" ) ) != NULL )
    {
       char buf[500];
       char buf2[600];
       int count = 0;
    
       while ( fgets ( buf, 500, fp ) )
       {
           sprintf ( buf2, "%d %s", count++, buf );
           XmTextInsert ( text, XmTextGetLastPosition(text),
                          buf2);     
        }

       fclose ( fp );
    }

    XtRealizeWidget ( shell );
    WaitForWindow ( shell );
    XmUpdateDisplay ( shell );
    ReportTime ( "Up",  TRUE );

    ReportTime ( "Ready" ,  TRUE );
  
    XtAppMainLoop ( app );
}

