/********************************************************************
 *         This example code is from the book:
 *
 *           Motif Debuggin and Performance Tuning
 *            ISBN 0-13-147984-9
 *         by
 *           Douglas Young
 *           Prentice Hall, 1995
 *
 *         Copyright 1994 by Prentice Hall
 *         All Rights Reserved
 *
 *  Permission to use, copy, modify, and distribute this software for 
 *  any purpose except publication and without fee is hereby granted, provided 
 *  that the above copyright notice appear in all copies of the software.
 * *****************************************************************************/

/*******************************************************
 * menu.c: measure time required to create menu panes.
 *******************************************************/
#include <Xm/Xm.h>
#include <Xm/MainW.h>
#include <Xm/CascadeB.h>
#include <Xm/RowColumn.h>
#include <Xm/PushB.h>
#include "TimerTools.h"

void CreatePane ( Widget parent ) 
{
    Widget cascade, submenu;
    int    i;

   /*
    * Create a menu pane with 10 items. Assume 
    * parent is a menu bar or menu pane.
    */

    submenu = XmCreatePulldownMenu ( parent, 
                                    "Submenu", 
                                     NULL, 0 );

    cascade = 
         XtVaCreateManagedWidget ( "Submenu",
                                   xmCascadeButtonWidgetClass,
                                   parent, 
                                   XmNsubMenuId, submenu,
                                   NULL );
    for ( i = 0; i < 10; i++ )
        XtCreateManagedWidget ( "Item",
                                xmPushButtonWidgetClass,
                                submenu, NULL, 0 );
}

Widget CreateMenu ( Widget parent ) 
{
    Widget menu;
    int    i;

   /*
    * Create a menu bar with six panes.
    */

    menu = XmCreateMenuBar ( parent, "menu", NULL, 0 );

    for ( i = 0; i < 6; i++ )
        CreatePane ( menu );

    XtManageChild ( menu );
    return ( menu );
}


void main ( int argc, char ** argv ) 
{
    Widget       shell, mainWindow, menu;
    XtAppContext app;

    ReportTime ( "Starting", TRUE );
    shell = XtAppInitialize (  &app, "Menu", NULL, 0, 
                               &argc, argv, NULL, NULL, 0 );

    mainWindow = 
             XtCreateManagedWidget ( "mainWindow", 
                                     xmMainWindowWidgetClass,
                                     shell, NULL, 0 );

    /*
     * Create a menubar and install it into the main window. 
     */
    
    menu =  CreateMenu ( mainWindow );

    XtVaSetValues ( mainWindow,
                    XmNmenuBar, menu, 
                    NULL );

    XtRealizeWidget ( shell );

    WaitForWindow ( shell );
    HandleEvents ( shell );

    ReportTime ( "Up", TRUE );
    
    XtAppMainLoop ( app );
}

