/********************************************************************
 *         This example code is from the book:
 *
 *           Motif Debuggin and Performance Tuning
 *            ISBN 0-13-147984-9
 *         by
 *           Douglas Young
 *           Prentice Hall, 1995
 *
 *         Copyright 1994 by Prentice Hall
 *         All Rights Reserved
 *
 *  Permission to use, copy, modify, and distribute this software for 
 *  any purpose except publication and without fee is hereby granted, provided 
 *  that the above copyright notice appear in all copies of the software.
 * *****************************************************************************/

/**************************************************
 * menu.c: Show how work procedures can be used 
 *         to delay menu creation.
 ***************************************************/
#include <Xm/Xm.h>
#include <Xm/MainW.h>
#include <Xm/CascadeBG.h>
#include <Xm/RowColumn.h>
#include <Xm/PushBG.h>

#include "TimerTools.h"

typedef struct {
  Widget menubar;
  Widget cascade;
} WidgetPair;

Boolean CreatePaneWorkProc ( XtPointer clientData );

void CreatePane ( Widget parent )
{
   /*
    * Allocate a structure to be used for info needed by 
    * work procedure.
    */

    WidgetPair *wp = ( WidgetPair* )
                          XtMalloc ( sizeof(WidgetPair ) );
   /*
    * Create a cascade button for this pane. Store menubar
    * and cascade in the structure.
    */

    wp->menubar = parent;
    wp->cascade = XtCreateManagedWidget ( "Submenu",
                                 xmCascadeButtonGadgetClass,
                                 parent, NULL, 0  );
   /*
    * Register a work procedure to create the rest of the pane
    * when the application has a chance.
    */

    XtAppAddWorkProc ( XtWidgetToApplicationContext ( parent ),
                       CreatePaneWorkProc,
                       ( XtPointer ) wp );
}

Boolean CreatePaneWorkProc ( XtPointer clientData )
{
    WidgetPair *wp = (WidgetPair*) clientData;
    Widget submenu;
    Widget buttons[10];
    int    i;

   /*
    * Create a pulldown menu pane as a child of the 
    * given menubar.
    */

    submenu = XmCreatePulldownMenu ( wp->menubar, 
                                     "Submenu", 
                                     NULL, 0 );
   /*
    * Attach this menu pane to the cascade specified in the
    * client data structure.
    */

    XtVaSetValues ( wp->cascade,
                    XmNsubMenuId, submenu,
                    NULL);
   /*
    * Add items to the menu pane.
    */

    for ( i = 0; i < 10; i++ )
        buttons[i] = XtCreateWidget ( "Item",
                                      xmPushButtonGadgetClass,
                                      submenu, NULL, 0 );
    XtManageChildren ( buttons, 10 );
 
   /*
    * Free the client data structure, because this is 
    * only place we know that we are done with this memory.
    */

    XtFree ( (char *) wp );
   /*
    * Report the time elapsed before creating this pane.
    */

    ReportTime ( "Pane Created", TRUE );  

   /*
    * This work procedure should be called only once per
    * registration, so return TRUE.
    */

    return ( TRUE );
}


Widget CreateMenu ( Widget parent ) 
{
    Widget menu;
    int    i;

   /*
    * Create a menu bar with six panes.
    */

    menu = XmCreateMenuBar ( parent, "menu", NULL, 0 );

    for ( i = 0; i < 6; i++ )
        CreatePane ( menu );

    XtManageChild ( menu );
    return ( menu );
}

void main ( int argc, char ** argv ) 
{
    Widget       shell, mainWindow, menu;
    XtAppContext app;

    ReportTime ( "Starting", TRUE );
    shell = XtAppInitialize (  &app, "Menu", NULL, 0, 
                               &argc, argv, NULL, NULL, 0 );

    mainWindow = 
             XtCreateManagedWidget ( "mainWindow", 
                                     xmMainWindowWidgetClass,
                                     shell, NULL, 0 );

    /*
     * Create a menubar and install it into the main window. 
     */
    
    menu =  CreateMenu ( mainWindow );

    XtVaSetValues ( mainWindow,
                    XmNmenuBar, menu, 
                    NULL );

    XtRealizeWidget ( shell );

    WaitForWindow ( shell );
    HandleEvents ( shell );

    ReportTime ( "Up", TRUE );
    
    XtAppMainLoop ( app );
}

