/********************************************************************
 *         This example code is from the book:
 *
 *           Motif Debuggin and Performance Tuning
 *            ISBN 0-13-147984-9
 *         by
 *           Douglas Young
 *           Prentice Hall, 1995
 *
 *         Copyright 1994 by Prentice Hall
 *         All Rights Reserved
 *
 *  Permission to use, copy, modify, and distribute this software for 
 *  any purpose except publication and without fee is hereby granted, provided 
 *  that the above copyright notice appear in all copies of the software.
 * *****************************************************************************/

/************************************************************
 * permissions.c: Layout for first permissions panel design.
 ************************************************************/
#include <Xm/Xm.h>
#include <Xm/Label.h>
#include <Xm/Frame.h>
#include <Xm/Form.h>
#include <Xm/RowColumn.h>
#include <Xm/PushB.h>
#include "TimerTools.h"

Widget CreateOption ( Widget parent, char *name )
{
    Arg args[2];
    Widget pane, option, yes, no, asis;
    
   /*
    * Create a single Yes/No/As-Is option menu.
    */

    pane = XmCreatePulldownMenu ( parent, "pane", NULL, 0 );
    
    XtSetArg ( args[0], XmNsubMenuId, pane );
    option = XmCreateOptionMenu ( parent, name, args, 1 );
    XtManageChild ( option );
    
    yes = XtCreateManagedWidget ( "Yes", 
                                  xmPushButtonWidgetClass,
                                  pane, NULL, 0);
    
    no = XtCreateManagedWidget ( "No",
                                 xmPushButtonWidgetClass,
                                 pane, NULL, 0);
    
    asis = XtCreateManagedWidget ( "As-Is",
                                   xmPushButtonWidgetClass,
                                   pane, NULL, 0); 
    return( option );
}

Widget  CreateRWE ( Widget parent, char *name )
{
    Widget frame, label, rowcolumn;
    
   /*
    * Create a labeled frame containing a row of option menus
    */

    frame = XtVaCreateManagedWidget ( "frame",
                           xmFrameWidgetClass, parent,
                           XmNshadowType, XmSHADOW_ETCHED_IN,
                           NULL );
    
    label = XtVaCreateManagedWidget ( name,
                           xmLabelWidgetClass, frame,
                           XmNchildType, XmFRAME_TITLE_CHILD,
                           NULL );
    
    rowcolumn = XtVaCreateManagedWidget ( "rowColumn",
                        xmRowColumnWidgetClass,frame,
                        XmNorientation,   XmHORIZONTAL,
                        XmNpacking,       XmPACK_COLUMN,
                        XmNchildType, XmFRAME_WORKAREA_CHILD,
                        NULL );
    
    CreateOption ( rowcolumn, "Readable" );
    CreateOption ( rowcolumn, "Writable" );
    CreateOption ( rowcolumn, "Executable" );
    
    return ( frame );
}

Widget CreatePermissionPanel ( Widget parent)
{
    Widget form1, frame1, form, rowColumn1,
           label, user, group, other;
    
    form1 = XtCreateManagedWidget ( "form",
                                    xmFormWidgetClass,
                                    parent, NULL, 0 );
    
    
    frame1 = XtVaCreateManagedWidget ( "frame1",
                    xmFrameWidgetClass, form1,
                    XmNshadowType,       XmSHADOW_ETCHED_OUT,
                    XmNtopAttachment,    XmATTACH_FORM,
                    XmNbottomAttachment, XmATTACH_FORM,
                    XmNleftAttachment,   XmATTACH_FORM,
                    XmNrightAttachment,  XmATTACH_FORM,
                    XmNtopOffset,        10,
                    XmNbottomOffset,     10,
                    XmNleftOffset,       10,
                    XmNrightOffset,      10,
                    NULL );

    label = XtVaCreateManagedWidget ( "Permissions",
                           xmLabelWidgetClass, frame1,
                           XmNchildType, XmFRAME_TITLE_CHILD,
                           NULL );
    
    form = XtVaCreateManagedWidget ( "form",
                        xmFormWidgetClass, frame1,
                        XmNchildType, XmFRAME_WORKAREA_CHILD,
                        NULL );
    
    rowColumn1 = XtVaCreateManagedWidget ( "rowColumn1",
                          xmRowColumnWidgetClass, form,
                          XmNtopAttachment,    XmATTACH_FORM,
                          XmNbottomAttachment, XmATTACH_FORM,
                          XmNleftAttachment,   XmATTACH_FORM,
                          XmNrightAttachment,  XmATTACH_FORM,
                          XmNtopOffset,        20,
                          XmNbottomOffset,     20,
                          XmNleftOffset,       20,
                          XmNrightOffset,      20,
                          XmNrowColumnType,    XmWORK_AREA,
                          NULL );
     
    user =  CreateRWE ( rowColumn1, "User" );
    group = CreateRWE ( rowColumn1, "Group" );
    other = CreateRWE ( rowColumn1, "Other" );
    
    return ( form1 );
}

void main ( int argc, char **argv )
{
    Widget        shell;
    XtAppContext  app;
 
    ReportTime ( "Starting", FALSE );    
 
    shell = XtAppInitialize ( &app, "Permissions", NULL, 0, 
                              &argc, argv, NULL, NULL, 0 ); 
 
    ReportTime ( "Creating panel", TRUE );

    CreatePermissionPanel ( shell );
    
    XtRealizeWidget ( shell );

    WaitForWindow ( shell );    
    HandleEvents ( shell );

    ReportTime ( "Panel up", TRUE );    
    
    XtAppMainLoop ( app );
}    

