/********************************************************************
 *         This example code is from the book:
 *
 *           Motif Debuggin and Performance Tuning
 *            ISBN 0-13-147984-9
 *         by
 *           Douglas Young
 *           Prentice Hall, 1995
 *
 *         Copyright 1994 by Prentice Hall
 *         All Rights Reserved
 *
 *  Permission to use, copy, modify, and distribute this software for 
 *  any purpose except publication and without fee is hereby granted, provided 
 *  that the above copyright notice appear in all copies of the software.
 * *****************************************************************************/

/************************************************************
 * permissions.c: Layout for first permissions panel design.
 ************************************************************/
#include <Xm/Xm.h>
#include <Xm/Label.h>
#include <Xm/Frame.h>
#include <Xm/Form.h>
#include <Xm/RowColumn.h>
#include <Xm/PushB.h>
#include "TimerTools.h"

/************************************************************
 * permissions2.c: Layout for second design.
 ************************************************************/
#include <Xm/Xm.h>
#include <Xm/LabelG.h>
#include <Xm/Frame.h>
#include <Xm/Form.h>
#include <Xm/RowColumn.h>
#include <Xm/ToggleBG.h>
#include "TimerTools.h"

Widget CreateRWE ( Widget parent, char *name )
{
    Widget label, readable, writable, executable;
    
    Widget rc = XtVaCreateManagedWidget ( "rc",
                                xmRowColumnWidgetClass, 
                                parent,
                                XmNorientation, XmHORIZONTAL,
                                XmNpacking, XmPACK_COLUMN,
                                NULL );

    label = XtCreateManagedWidget ( name,
                                    xmLabelGadgetClass, rc,
                                    NULL, 0);

    readable = XtCreateManagedWidget ( "Readable",
                                   xmToggleButtonGadgetClass,
                                   rc, NULL, 0 );

    writable = XtCreateManagedWidget ( "Writable",
                                   xmToggleButtonGadgetClass,
                                   rc, NULL, 0);

    executable = XtCreateManagedWidget ( "Executable",
                                   xmToggleButtonGadgetClass,
                                   rc, NULL, 0);
    return ( rc );
}

Widget CreatePermissionPanel ( Widget parent )
{
    Widget  form1, frame1, form, rowColumn1, label;
    
    form1 = XtCreateManagedWidget ( "permissions",
                                    xmFormWidgetClass,
                                    parent, NULL, 0);
    
    frame1 = XtVaCreateManagedWidget ( "frame1",
                     xmFrameWidgetClass,  form1,
                     XmNshadowType,       XmSHADOW_ETCHED_OUT,
                     XmNtopAttachment,    XmATTACH_FORM,
                     XmNbottomAttachment, XmATTACH_FORM,
                     XmNleftAttachment,   XmATTACH_FORM,
                     XmNrightAttachment,  XmATTACH_FORM,
                     XmNtopOffset,        10,
                     XmNbottomOffset,     10,
                     XmNleftOffset,       10,
                     XmNrightOffset,      10,
                     NULL );

    label = XtVaCreateManagedWidget ( "Permissions",
                           xmLabelWidgetClass, frame1,
                           XmNchildType, XmFRAME_TITLE_CHILD,
                           NULL );
    
    rowColumn1 = XtVaCreateManagedWidget ( "rowColumn1",
                               xmRowColumnWidgetClass,
                               frame1,
                               XmNorientation,    XmVERTICAL,
                               NULL );
    
    CreateRWE ( rowColumn1, "User" );
    CreateRWE ( rowColumn1, "Group" );
    CreateRWE ( rowColumn1, "Other" );
    
    return( form1 );
}

void main ( int argc, char **argv )
{
    Widget        shell;
    XtAppContext  app;
 
    ReportTime ( "Starting", FALSE );    
 
    shell = XtAppInitialize ( &app, "Permissions", NULL, 0, 
                              &argc, argv, NULL, NULL, 0 ); 
 
    ReportTime ( "Creating panel", TRUE );

    CreatePermissionPanel ( shell );
    
    XtRealizeWidget ( shell );

    WaitForWindow ( shell );    
    HandleEvents ( shell );

    ReportTime ( "Panel up", TRUE );    
    
    XtAppMainLoop ( app );
}    

