/********************************************************************
 *         This example code is from the book:
 *
 *           Motif Debuggin and Performance Tuning
 *            ISBN 0-13-147984-9
 *         by
 *           Douglas Young
 *           Prentice Hall, 1995
 *
 *         Copyright 1994 by Prentice Hall
 *         All Rights Reserved
 *
 *  Permission to use, copy, modify, and distribute this software for 
 *  any purpose except publication and without fee is hereby granted, provided 
 *  that the above copyright notice appear in all copies of the software.
 * *****************************************************************************/

/*******************************************************
 * startupscr.c: Demonstrate a startup screen. 
 *******************************************************/
#include <Xm/Xm.h> 
#include <Xm/MainW.h>
#include <Xm/MessageB.h>
#include "TimerTools.h"

static Boolean startupScreenVisible = FALSE;

void DialogMapped ( Widget w,
                    XtPointer clientData,
                    XtPointer callData)
{
    startupScreenVisible = TRUE;
}

void main ( int argc, char **argv )
{
    Widget       hiddenShell, shell, dialog;
    XtAppContext app;
    Display     *dpy;


    ReportTime ( "Starting", TRUE );

   /*
    * Initialize Xt and create a hidden shell that is never
    * seen. Set XmNmappedWhenManaged to FALSE to allow this 
    * shell to serve as the parent of a dialog.
    */
  
    hiddenShell =
              XtVaAppInitialize ( &app, "Startupscr", NULL, 0,
                                  &argc, argv, NULL, 
                                  XmNmappedWhenManaged, FALSE,
                                  NULL );
    dpy = XtDisplay ( hiddenShell );

   /*
    * Position the shell in the middle of the screen so 
    * dialogs will be centered on the screen.
    */

    XtVaSetValues ( hiddenShell,
                    XmNx, DisplayWidth (dpy, 0 )  / 2,
                    XmNy, DisplayHeight ( dpy, 0 ) / 2,
                    NULL );

   /*
    * Realize the shell. Because XmNmappedWhenManaged is
    * FALSE, the shell does not appear.
    */

    XtRealizeWidget ( hiddenShell );
   
   /*
    * Create a dialog that serves as a simple startup screen.
    */


    dialog = XmCreateInformationDialog ( hiddenShell,
                                         "startupscreen",
                                         NULL, 0 );
   /*
    * Add a callback to be called when the widget is mapped.
    */

    XtAddCallback ( dialog, XmNmapCallback,
                    DialogMapped, ( XtPointer ) NULL );
    
   /*
    * Manage the dialog to make it appear.
    */

    XtManageChild ( dialog );

   /*
    * Without extra steps, the dialog will not actually 
    * appear, or be redrawn until the application 
    * reaches the event loop. To force the dialog to appear
    * as soon as possible, call XSync to force the X 
    * server to handle all requests and then enter 
    * an event loop. The event loop can be exited when the  
    * dialog is mapped, as determined by the value of
    * startupScreenVisible, which is set in the 
    * DialogMapped callback.
    */

    XSync ( XtDisplay ( hiddenShell ), 0 );

    while ( !startupScreenVisible )
    {
        XEvent event;
        XtAppNextEvent ( app, &event );
        XtDispatchEvent ( &event );
    }

    XmUpdateDisplay ( hiddenShell );

    ReportTime ( "Startup Screen Visible", TRUE );

   /*
    * Simulate a lengthy task by sleeping for a while.
    */

    sleep ( 15 );
  
    /*
     * Create the rest of the programs user interface. 
     */
  
    shell = XtCreatePopupShell ( "shell1",
                                 topLevelShellWidgetClass,
                                 hiddenShell, NULL, 0 );
  
    XtCreateManagedWidget ( "Widget", xmMainWindowWidgetClass, 
                            shell, NULL, 0 );

   /* Other UI and application setup. */
  
    XtPopup ( shell, XtGrabNone );

   /* Dismiss the start-up dialog. */

    XtUnmanageChild ( dialog );

    XtAppMainLoop ( app );
}

