/********************************************************************
 *         This example code is from the book:
 *
 *           Motif Debuggin and Performance Tuning
 *            ISBN 0-13-147984-9
 *         by
 *           Douglas Young
 *           Prentice Hall, 1995
 *
 *         Copyright 1994 by Prentice Hall
 *         All Rights Reserved
 *
 *  Permission to use, copy, modify, and distribute this software for 
 *  any purpose except publication and without fee is hereby granted, provided 
 *  that the above copyright notice appear in all copies of the software.
 * *****************************************************************************/

/************************************************
 * timetest2.c : Test Xt initialization time.
 ************************************************/
#include <Xm/Xm.h>
#include "TimerTools.h"

void main ( int argc, char **argv ) 
{
    Widget       shell;
    XtAppContext app;
    Display     *dpy;

    ReportTime ( "Starting", FALSE );
    
    XtToolkitInitialize();        

    ReportTime ( "Xt inited", TRUE );
    
    app = XtCreateApplicationContext();

    ReportTime ( "App context created", TRUE );    
    
    dpy = XtOpenDisplay ( app, NULL, NULL, "Timetest", 
                          NULL, 0, &argc, argv );

    ReportTime ( "Display opened", TRUE );
    
    shell = XtAppCreateShell ( NULL, "shell", 
                               applicationShellWidgetClass,
                               dpy, NULL, 0 );

    ReportTime ( "Shell created", TRUE );
    HandleEvents ( shell );
    ReportTime ( "Finished", TRUE );
}

