/********************************************************************
 *         This example code is from the book:
 *
 *           Motif Debuggin and Performance Tuning
 *            ISBN 0-13-147984-9
 *         by
 *           Douglas Young
 *           Prentice Hall, 1995
 *
 *         Copyright 1994 by Prentice Hall
 *         All Rights Reserved
 *
 *  Permission to use, copy, modify, and distribute this software for 
 *  any purpose except publication and without fee is hereby granted, provided 
 *  that the above copyright notice appear in all copies of the software.
 * *****************************************************************************/

/********************************************************
 * widgettest.c: Experiment with creating many widgets.
 ********************************************************/
#include <Xm/Xm.h>
#include <Xm/RowColumn.h>
#include <Xm/Form.h>
#include <Xm/PushB.h>
#include <Xm/PushBG.h>
#include "TimerTools.h"

int         numWidgets     = 100;
Boolean     manageAll      = FALSE;
Boolean     useGadgets     = FALSE;
Boolean     afterRealize   = FALSE;
Boolean     unmanagedParent   = TRUE;

/*
 * Set up command-line arguments.
 */

static XtResource resources[] = {
{ "numWidgets", "NumWidgets", XmRInt, sizeof(int),
        ( Cardinal )  &numWidgets,  XmRImmediate, 
        ( XtPointer )  100 },
{ "manageAll", "ManageAll", XmRBoolean, sizeof  ( Boolean ),
        ( Cardinal ) &manageAll,  XmRString, "FALSE" },
{ "afterRealize", "AfterRealize", XmRBoolean,
   sizeof  ( Boolean ),
        ( Cardinal ) &afterRealize,  XmRString, "FALSE"},
{ "useGadgets", "UseGadgets", XmRBoolean, sizeof  ( Boolean ),
        ( Cardinal ) &useGadgets,  XmRString, "FALSE" },
{ "unmanagedParent", "UnmanagedParent", XmRBoolean,
   sizeof  ( Boolean ),
        ( Cardinal ) &unmanagedParent,  XmRString, "TRUE" },
};

XrmOptionDescRec options[] = {
  {"-numWidgets",   "*numWidgets",   XrmoptionSepArg, NULL },
  {"-useGadgets",   "*useGadgets",   XrmoptionNoArg, "TRUE"},
  {"-manageAll",    "*manageAll",    XrmoptionNoArg, "TRUE"},
  {"-afterRealize", "*afterRealize", XrmoptionNoArg, "TRUE"},
  {"-unmanagedParent", "*unmanagedParent", 
                                     XrmoptionNoArg, "FALSE"},
};

void main ( int argc, char **argv ) 
{
    Widget       shell, rowcol, form;
    XtAppContext app;
    int          i;
    WidgetList   widgets;
    WidgetClass  widgetType = xmPushButtonWidgetClass;

    shell = XtAppInitialize ( &app, "Widgettest",         
                              options, XtNumber ( options ),
                              &argc, argv, NULL, NULL, 0 );
   /*
    * Load options.
    */

    XtGetApplicationResources ( shell, 0, resources,         
                                XtNumber ( resources ),
                                NULL, 0  );

   /*
    * Allocate a list in which to keep all children.
    */

    widgets = ( WidgetList ) XtMalloc ( sizeof( Widget ) *
                                        numWidgets );
   /*
    * If gadgets are to be used, change the class pointer.
    */

    if ( useGadgets )
        widgetType = xmPushButtonGadgetClass;

   /*
    * Create the manager widgets.
    */

    form = XtVaCreateManagedWidget ( "form", 
                                     xmFormWidgetClass,
                                     shell, NULL );
    
    rowcol = XtVaCreateWidget ( "rowcol",
                                xmRowColumnWidgetClass, form,
                                XmNnumColumns, 20,
                                NULL );
   /*
    * Start timing from the point after the parents have 
    * been created.
    */

    ReportTime ( "Row Column Created", FALSE );

   /*
    * Manage the parent now, if this option is not selected.
    */

    if ( !unmanagedParent )
        XtManageChild ( rowcol );

   /*
    * If we are measuring the effect of managing children of
    * a realized widget, realize the shell now.
    */

    if ( afterRealize )
    {
        XtRealizeWidget ( shell );
    }

   /*
    * Create the children of the XmRowColumn widget. If
    * children are to be managed in groups, store each child
    * in an array  and then call XtManageChildren(). 
    * Otherwise, just call XtCreateManagedWidget().
    */ 

    if ( manageAll )
    {
        for ( i = 0; i < numWidgets; i++ )  
            widgets[i] = XtCreateWidget ( "button", widgetType,
                                          rowcol, NULL, 0 );
        XtManageChildren ( widgets, numWidgets );
    }
    else
       for ( i = 0; i < numWidgets; i++ )  
            XtCreateManagedWidget ( "button", widgetType,
                                    rowcol, NULL, 0 );
   /*
    * Now that all children are managed, handle the parent,
    * depending on the options specified. Manage and/or
    * realize, if necessary.
    */

    if ( unmanagedParent )
        XtManageChild ( rowcol );
    
    if ( !afterRealize )
        XtRealizeWidget ( shell );

   /*
    * Now wait for the shell to appear on the screen. 
    * Handle all pending events, to ensure
    * repeatable behavior for measurements.
    */

    WaitForWindow( shell );
    HandleEvents ( shell );

    ReportTime ( "UP", TRUE );
}

