/********************************************************************
 *         This example code is from the book:
 *
 *           Motif Debuggin and Performance Tuning
 *            ISBN 0-13-147984-9
 *         by
 *           Douglas Young
 *           Prentice Hall, 1995
 *
 *         Copyright 1994 by Prentice Hall
 *         All Rights Reserved
 *
 *  Permission to use, copy, modify, and distribute this software for 
 *  any purpose except publication and without fee is hereby granted, provided 
 *  that the above copyright notice appear in all copies of the software.
 * *****************************************************************************/

/*********************************************************
 * TimingTools.c: Simple functions to time performance.
 *********************************************************/
#include <stdio.h>
#include <sys/times.h>
#include <limits.h>
#include <unistd.h>
#include <X11/Intrinsic.h>


void ReportTime ( String msg, Boolean report )
{
    static int firstTime = TRUE;
    static struct tms  last;
    static struct tms  now;
    static clock_t  current, prev;    

   /*
    * Always print the message, if it exists.
    */

    if ( msg )
        printf ( "%s:\n", msg );
    
   /*
    * Report the time since the last call.
    */

    if ( !firstTime && report )
    {
        int user, sys, elapsed;

       /*
        * Get the time.
        */

        current = times ( &now );
        
       /*
        * Convert to milliseconds since the last call.
        */

        user    = 1000 * ( now.tms_utime - last.tms_utime ) / 
                                                     CLK_TCK;
        sys     = 1000 * ( now.tms_stime - last.tms_stime ) /
                                                     CLK_TCK;
        elapsed = 1000 * ( current - prev ) / CLK_TCK;

       /*
        * Print the information in seconds and milliseconds.
        */

        printf ( "   Elapsed Time = %d.%03d\n",
                 elapsed / 1000, elapsed % 1000 );
        printf ( "   User Time     = %d.%03d\n", 
                 user / 1000, user % 1000 );
        printf ( "   System Time  = %d.%03d\n",
                 sys / 1000, sys % 1000 );
    }

    firstTime = FALSE;

   /*
    * Get the current time to be used in the next calculation.
    */

    prev = times ( &last );
}


void HandleEvents ( Widget w )
{
    XtAppContext app;    
    XEvent       event;
    XtInputMask  mask;

    app = XtWidgetToApplicationContext ( w );

    XSync ( XtDisplay ( w ), 0 );
    
    while ( mask = XtAppPending ( app ) )
    {
        XtAppNextEvent ( app, &event );
        
        XtDispatchEvent ( &event );
        
    }
}

void WaitForWindow ( Widget w )
{
    XtAppContext app;    
    XEvent       event;
    XtInputMask  mask;

    app = XtWidgetToApplicationContext ( w );

    XSync ( XtDisplay ( w ), 0 );
    
    while ( TRUE )
    {
        XtAppNextEvent ( app, &event );
        
        XtDispatchEvent ( &event );

        if ( event.xany.type == MapNotify &&
             event.xany.window == XtWindow ( w ) )
          return;
    }
}

