/* $XConsortium: AllCmap.c,v 1.6 89/10/08 14:52:32 rws Exp $
 * 
 * Copyright 1989 by the Massachusetts Institute of Technology
 *
 * Permission to use, copy, modify, and distribute this software and its
 * documentation for any purpose and without fee is hereby granted, provided 
 * that the above copyright notice appear in all copies and that both that 
 * copyright notice and this permission notice appear in supporting 
 * documentation, and that the name of M.I.T. not be used in advertising
 * or publicity pertaining to distribution of the software without specific, 
 * written prior permission. M.I.T. makes no representations about the 
 * suitability of this software for any purpose.  It is provided "as is"
 * without express or implied warranty.
 *
 * M.I.T. DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING ALL
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL M.I.T.
 * BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
 * WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION
 * OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN
 * CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
 *
 * Author:  Donna Converse, MIT X Consortium
 *
 *
 *                                                                            
 *  (c) Copyright Hewlett-Packard Company, 1993, Fort Collins, Colorado       
 *                                                                            
 *                            All Rights Reserved                             
 *                                                                            
 *  Permission to use, copy, modify, and distribute this software and its     
 *  documentation for any purpose and without fee is hereby granted,          
 *  provided that the above copyright notices appear in all copies and that   
 *  both the copyright notices and this permission notice appear in           
 *  supporting documentation, and that the name of Hewlett-Packard not be     
 *  used in advertising or publicity pertaining to distribution of the        
 *  software without specific, written prior permission.                      
 *                                                                            
 *  HEWLETT-PACKARD MAKES NO WARRANTY OF ANY KIND WITH REGARD TO THIS         
 *  SOFTWARE, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF        
 *  MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.  Hewlett-Packard    
 *  shall not be liable for errors contained herein or direct, indirect,      
 *  special, incidental or consequential damages in connection with the       
 *  furnishing, performance or use of this software.                          
 *
 *  Modifications for PEX:  John Waitz, Hewlett-Packard Company
 */

#include <stdio.h>
#include <X11/Xlib.h>
#include <X11/Xatom.h>
#include <X11/Xutil.h>
#include <X11/Xmu/StdCmap.h>
#include <X11/Xmu/StdCmapExt.h>
#ifdef PEX_SUPPORT /* [ */
#include <X11/PEX5/PEXlib.h>
#endif /* ] PEX_SUPPORT */
 
static XVisualInfo *getDeepestVisual();

/*
 * To create all of the appropriate standard colormaps for every visual of
 * every screen on a given display, use XmuAllStandardColormapsExt().
 *
 * Define and retain as permanent resources all standard colormaps which are
 * meaningful for the visuals of each screen of the display.  Return 0 on
 * failure, non-zero on success.  If the property of any standard colormap 
 * is already defined, redefine it.
 *
 * This interface is intended to be used by window managers or a client
 * upon start-up of a session.
 *
 * The standard colormaps of a screen are defined by properties associated
 * with the screen's root window.  Each screen has exactly one root window.
 * The property names of standard colormaps are predefined, and each property
 * name may describe at most one colormap.
 * 
 * The standard colormaps are
 *		RGB_BEST_MAP
 *		RGB_RED_MAP
 *		RGB_GREEN_MAP
 *		RGB_BLUE_MAP
 *		RGB_DEFAULT_MAP
 *		RGB_GRAY_MAP
 *
 *
 * Therefore a screen may have at most 6 standard colormap properties defined.
 *
 * A standard colormap is associated with a particular visual of the screen.
 * A screen may have multiple visuals defined, including visuals of the same
 * class at different depths.  Note that a visual id might be repeated for
 * more than one depth, so the visual id and the depth of a visual identify
 * the visual.  The characteristics of the visual will determine which
 * standard colormaps are meaningful under that visual, and will determine
 * how the standard colormap is defined.  Because a standard colormap is
 * associated with a specific visual, there must be a method of determining
 * which visuals take precedence in defining standard colormaps.
 * 
 * The method used here is: for the visual of greatest depth, define all 
 * standard colormaps meaningful to that visual class.  The visual is chosen
 * according to this order of (descending) precedence:
 *
 * Without the XMU_CONTROL_PEX_SUPPORTED requirement:
 *
 *	if there is a DirectColor or PseudoColor Visual
 *        the one with the most colors is chosen for all properties, 
 *	  PseudoColor preferred in a tie
 *	else
 *	  if there is a TrueColor it is chosen 
 *	  else if a StaticColor it is chosen
 *
 *	  if there is a GrayScale it is chosen (possibly in addition to
 *          to TrueColor/StaticColor)
 *	  else if there is a StaticGray it is chosen (possibly in addition to
 *          to TrueColor/StaticColor)
 *
 * With the XMU_CONTROL_PEX_SUPPORTED requirement:
 *
 *	if there is a TrueColor, DirectColor, or PseudoColor Visual
 *        the one with the most colors is chosen for all properties, 
 *	  tiebreaker order is TrueColor, DirectColor, PseudoColor
 *	else
 *	  if there is a StaticColor it is chosen
 *
 *	  if there is a GrayScale it is chosen (possibly in addition to
 *          to StaticColor)
 *	  else if there is a StaticGray it is chosen (possibly in addition to
 *          to StaticColor)
 *
 * Allows partial success by screenful.  For example, if a map on screen 1
 * fails, the maps on screen 0, created earlier, will remain.  However,
 * none on screen 1 will remain.  If a map on 0 fails, none will remain.
 *
 * See the comments under XmuVisualStandardColormapsExt() for notes on which
 * standard colormaps are meaningful under these classes of visuals.
 */

Status XmuAllStandardColormapsExt(dpy, params)
    Display		*dpy;	/* Specifies the connection to the X server */
    XmuExtendedParams 	*params;/* controls and hints */
{
    int 		nvisuals, scr;
    Status		status;
    long		vinfo_mask;
    XVisualInfo		template, *vinfo;
    XVisualInfo		*v0 = NULL, *v1 = NULL, *v2 = NULL, *v_chosen = NULL;
    int			ncolors_v0 = 0, ncolors_v1 = 0, ncolors_v2 = 0;
    int			ncolors_chosen = 0;
    unsigned long	ntargets = 0;
    char *		targets = NULL;
#ifdef PEX_SUPPORT /* [ */
    int			PEX_required = False;
    int			PEX_required_on_screen = False;
    int			pex_control_index;
#endif /* ] PEX_SUPPORT */

    /*
	Decipher the controls and hints currently supported in this procedure.
	Set flags for the PEX requirement, and for the static policy hint.
    */
    if (params) {
	int i;

#ifdef PEX_SUPPORT /* [ */
	for (i=0; i < params->num_controls; i++) {
	    if (params->controls[i].name == XMU_CONTROL_PEX_SUPPORTED) {
		PEX_required = params->controls[i].value;
		pex_control_index = i;
	    }
	}
#endif /* ] PEX_SUPPORT */
    }


    /* for each screen, determine all visuals of this server */
    for (scr=0; scr < ScreenCount(dpy); scr++)
    {
	status = 0;

	template.screen = scr;
	vinfo_mask = VisualScreenMask;
	vinfo = XGetVisualInfo(dpy, vinfo_mask, &template, &nvisuals);
	if (vinfo == NULL) /* unexpected: a screen with no visuals */
	    continue;

	targets = NULL;
	ntargets = 0;

#ifdef PEX_SUPPORT /* [ */
	/*
	    If PEX support is required, get the targets if possible.
	*/
	if (PEX_required) {
	    PEXExtensionInfo	*ext_info;

	    if (NULL == (ext_info = PEXGetExtensionInfo (dpy))) {
		XFree ((char *) vinfo);
		return 0;
	    }

	    if ((ext_info->major_version == 5) &&
		(ext_info->minor_version >= 1)) {

		if (! PEXMatchRenderingTargets (dpy, 
					    RootWindow(dpy, scr),
					    0, PEXWindowDrawable, NULL,
					    64, &ntargets, 
					    (PEXRenderingTarget**) &targets)) {
		    XFree ((char *) vinfo);
		    return 0;
		}
	    }

	    if (ntargets == 0) {
		/* 
		    If PEX is not supported on this screen (and it's not 
		    the only screen) then don't require PEX for this screen.
		*/
		if (ScreenCount(dpy) > 1) {
		    PEX_required_on_screen = False;
		    params->controls[pex_control_index].value = False;
		}
		else {
		    XFree ((char *) vinfo);
		    return 0;
		}
	    }
	    else
		PEX_required_on_screen = True;
	}

#endif /* ] PEX_SUPPORT */

	if (v1 = getDeepestVisual(DirectColor, vinfo, nvisuals, 
						targets, ntargets))
	    ncolors_v1 = ((v1->red_mask | v1->green_mask | v1->blue_mask) + 1);

	if (v2 = getDeepestVisual(PseudoColor, vinfo, nvisuals, 
						targets, ntargets))
	    ncolors_v2 = v2->colormap_size;

#ifdef PEX_SUPPORT /* [ */
	if (PEX_required_on_screen) {

	    if (v0 = getDeepestVisual(TrueColor, vinfo, nvisuals, 
						    targets, ntargets))
		ncolors_v0 = ((v0->red_mask | v0->green_mask | v0->blue_mask) 
				+ 1);

	    if (ncolors_v1 >= ncolors_v2) {
		v_chosen = v1;
		ncolors_chosen = ncolors_v1;
	    }
	    else {
		v_chosen = v2;
		ncolors_chosen = ncolors_v2;
	    }

	    if (ncolors_v0 >= ncolors_chosen) {
		v_chosen = v0;
		ncolors_chosen = ncolors_v0;
	    }
	}
	else {
#endif /* ] PEX_SUPPORT */

	if (ncolors_v2 >= ncolors_v1) 
	{
	    v_chosen = v2;
	    ncolors_chosen = ncolors_v2;
	}
	else 
	{
	    v_chosen = v1;
	    ncolors_chosen = ncolors_v1;
	}
#ifdef PEX_SUPPORT /* [ */
	}
#endif /* ] PEX_SUPPORT */

	if (v_chosen) {
	    status = XmuVisualStandardColormapsExt(dpy, scr, v_chosen->visualid,
					(unsigned) v_chosen->depth, 1, 1, 
					params);
	}
	else {
	    if ((
#ifdef PEX_SUPPORT /* [ */
		!PEX_required_on_screen && 
#endif /* ] PEX_SUPPORT */
		((v1 = getDeepestVisual(TrueColor, vinfo, nvisuals, 
				    targets, ntargets)) != NULL))
		|| ((v1 = getDeepestVisual(StaticColor, vinfo, nvisuals, 
				    targets, ntargets)) !=
		NULL))
		status = XmuVisualStandardColormapsExt(dpy, scr, 
			v1->visualid, (unsigned) v1->depth, 1, 1, params);
	    if (status && 
	       (((v1 = getDeepestVisual(GrayScale, vinfo, nvisuals, 
				    targets, ntargets)) != NULL)
		|| ((v1 = getDeepestVisual(StaticGray, vinfo, nvisuals, 
				    targets, ntargets)) != 
		    NULL)))
		status = XmuVisualStandardColormapsExt(dpy, scr, 
			v1->visualid, (unsigned) v1->depth, 1, 1, params);
	}

	XFree ((char *) vinfo);

#ifdef PEX_SUPPORT /* [ */
	if (PEX_required) {
	    params->controls[pex_control_index].value = True;
	    if (ntargets) XFree (targets);
	}
#endif /* ] PEX_SUPPORT */

	if (!status) break;
    }

    return status;
}


static XVisualInfo *getDeepestVisual(visual_class, vinfo, nvisuals, 
					targets, ntargets)
    int		visual_class;	/* specifies the visual class */
    XVisualInfo	*vinfo;		/* specifies all visuals for a screen */
    int		nvisuals;	/* specifies number of visuals in the list */
    char 	*targets;	/* PEX target list, NULL if PEX not required */
    int		ntargets;	/* specifes count of PEX targets */
{
    register int	i;
    unsigned int	maxdepth = 0;
    XVisualInfo		*v = NULL;
    
    for (i=0; i < nvisuals; i++, vinfo++) {

#ifdef PEX_SUPPORT /* [ */
	/*
	    Filter so only PEX-supported Visuals are considered.
	*/
	if (ntargets) {
	    int PEX_supported_on_Visual;
	    PEXRenderingTarget	*p_target;
	    int j;

	    PEX_supported_on_Visual = False;
	    for (j=0, p_target = (PEXRenderingTarget *) targets; 
		    j < ntargets; j++, p_target++) {

		if ((p_target->depth == vinfo->depth) &&
		   (XVisualIDFromVisual(p_target->visual) == vinfo->visualid)) {
		    PEX_supported_on_Visual = True;
		    break;
		}
	    }
	    if (!PEX_supported_on_Visual)
		continue;
	}
#endif /* ] PEX_SUPPORT */

	if (vinfo->class == visual_class && vinfo->depth > maxdepth)
	{
	    maxdepth = vinfo->depth;
	    v = vinfo;
	}
    }
    return(v);
}

