/* $XConsortium: StdCmap.c,v 1.13 92/11/24 14:16:21 rws Exp $ 
 * 
 * Copyright 1989 by the Massachusetts Institute of Technology
 *
 * Permission to use, copy, modify, and distribute this software and its
 * documentation for any purpose and without fee is hereby granted, provided 
 * that the above copyright notice appear in all copies and that both that 
 * copyright notice and this permission notice appear in supporting 
 * documentation, and that the name of M.I.T. not be used in advertising
 * or publicity pertaining to distribution of the software without specific, 
 * written prior permission. M.I.T. makes no representations about the 
 * suitability of this software for any purpose.  It is provided "as is"
 * without express or implied warranty.
 *
 * M.I.T. DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING ALL
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL M.I.T.
 * BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
 * WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION
 * OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN
 * CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
 *
 * Author:  Donna Converse, MIT X Consortium
 *                                                                            
 *                                                                            
 *                                                                            
 *  (c) Copyright Hewlett-Packard Company, 1993, Fort Collins, Colorado       
 *                                                                            
 *                            All Rights Reserved                             
 *                                                                            
 *  Permission to use, copy, modify, and distribute this software and its     
 *  documentation for any purpose and without fee is hereby granted,          
 *  provided that the above copyright notices appear in all copies and that   
 *  both the copyright notices and this permission notice appear in           
 *  supporting documentation, and that the name of Hewlett-Packard not be     
 *  used in advertising or publicity pertaining to distribution of the        
 *  software without specific, written prior permission.                      
 *                                                                            
 *  HEWLETT-PACKARD MAKES NO WARRANTY OF ANY KIND WITH REGARD TO THIS         
 *  SOFTWARE, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF        
 *  MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.  Hewlett-Packard    
 *  shall not be liable for errors contained herein or direct, indirect,      
 *  special, incidental or consequential damages in connection with the       
 *  furnishing, performance or use of this software.                          
 *
 * Modifications for PEX:  John Waitz, Hewlett-Packard Company
 *
 */

#include <stdio.h>
#include <X11/Xlib.h>
#include <X11/Xatom.h>
#include <X11/Xutil.h>
#include <X11/Xmu/StdCmap.h>
#include <X11/Xmu/StdCmapExt.h>
#ifdef PEX_SUPPORT /* [ */
#include <X11/PEX5/PEXlib.h>
#include <X11/Xmu/StdCmapPEX.h>
#endif /* ] PEX_SUPPORT */

#define lowbit(x) ((x) & (~(x) + 1))

extern char *malloc();
static Status valid_args();		/* argument restrictions */
#ifdef PEX_SUPPORT /* [ */
static Status verifyPEXSupport();
static Status createTemporaryWindow();
static Status destroyTemporaryWindow();
#endif /* ] PEX_SUPPORT */

/*
 * To create any one standard colormap, use XmuStandardColormapExt().
 *
 * Create a standard colormap for the given screen, visualid, and visual
 * depth, with the given red, green, and blue maximum values, with the
 * given standard property name.  Return a pointer to an XStandardColormap
 * structure which describes the newly created colormap, upon success.
 * Upon failure, return NULL.
 * 
 * XmuStandardColormapExt() calls XmuCreateColormapExt() to create the map.
 *
 * Resources created by this function are not made permanent; that is the
 * caller's responsibility.
 */

XStandardColormap *XmuStandardColormapExt(dpy, screen, visualid, depth, 
					property, cmap, 
					red_max, green_max, blue_max,
					params)
    Display		*dpy;		/* specifies X server connection */
    int			screen; 	/* specifies display screen */
    VisualID		visualid;	/* identifies the visual type */
    unsigned int	depth;		/* identifies the visual type */
    Atom		property;	/* a standard colormap property */
    Colormap		cmap;		/* specifies colormap ID or None */
    unsigned long	red_max, green_max, blue_max;	/* allocations */
    XmuExtendedParams 	*params;	/* controls and hints */
{
    XStandardColormap	*stdcmap;
    Status		status;
    XVisualInfo		vinfo_template, *vinfo;
    long		vinfo_mask;
    int			n;
    int			ramp_hint = RAMP_RGB;
#ifdef PEX_SUPPORT /* [ */
    int			PEX_required = False;
    XmuExtendedParams 	*local_params;
    int			allocated_params = False;
#endif /* ] PEX_SUPPORT */

    /*
	Decode the controls and hints supported in this procedure.
	Set flag for the PEX requirement, but don't set it unless 
	property is RGB_DEFAULT_MAP or RGB_BEST_MAP.
    */
    if (params) {
	int i;

#ifdef PEX_SUPPORT /* [ */
	for (i=0; i < params->num_controls; i++) {
	    if ((params->controls[i].name == XMU_CONTROL_PEX_SUPPORTED) &&
		((property == XA_RGB_DEFAULT_MAP) ||
		(property == XA_RGB_BEST_MAP)))
		PEX_required = params->controls[i].value;
	}
#endif /* ] PEX_SUPPORT */

	for (i=0; i < params->num_hints; i++) {
	    if (params->hints[i].name == XMU_HINT_PSEUDO_RAMP)
		ramp_hint = params->hints[i].value;
	}
    }


    /* Match the required visual information to an actual visual */
    vinfo_template.visualid = visualid;	
    vinfo_template.screen = screen;
    vinfo_template.depth = depth;
    vinfo_mask = VisualIDMask | VisualScreenMask | VisualDepthMask;
    if ((vinfo = XGetVisualInfo(dpy, vinfo_mask, &vinfo_template, &n)) == NULL)
	return 0;

    /* Check the validity of the combination of visual characteristics,
     * allocation, and colormap property.  Create an XStandardColormap
     * structure.
     */

    if (! valid_args(vinfo, red_max, green_max, blue_max, property)
	|| ((stdcmap = XAllocStandardColormap()) == NULL)) {
	XFree((char *) vinfo);
	return 0;
    }

#ifdef PEX_SUPPORT /* [ */
    /*
	If PEX is required, check support for the Visual.
    */
    if (PEX_required) {

	PEXExtensionInfo	*ext_info;
	PEXRenderingTarget	*targets;
	unsigned long		target_count;

	targets = NULL;
	target_count = 0;

	if (NULL == (ext_info = PEXGetExtensionInfo (dpy)))
	    return 0;

	if ((ext_info->major_version == 5) &&
	    (ext_info->minor_version >= 1)) {

	    if ((! PEXMatchRenderingTargets (dpy, 
					RootWindow(dpy, screen),
					depth, PEXWindowDrawable, vinfo->visual,
					1, &target_count, &targets)) ||
		(target_count == 0)) {
		XFree((char *) vinfo);
		return 0;
	    }

	    XFree (targets);
	}
    }
#endif /* ] PEX_SUPPORT */


    /* Fill in the XStandardColormap structure */

    if (cmap == DefaultColormap(dpy, screen)) {
	/* Allocating out of the default map, cannot use XFreeColormap() */
	Window win = XCreateWindow(dpy, RootWindow(dpy, screen), 1, 1, 1, 1,
				   0, 0, InputOnly, vinfo->visual,
				   (unsigned long) 0,
				   (XSetWindowAttributes *)NULL);
	stdcmap->killid  = (XID) XCreatePixmap(dpy, win, 1, 1, depth);
	XDestroyWindow(dpy, win);
	stdcmap->colormap = cmap;
    } else {
	stdcmap->killid = ReleaseByFreeingColormap;
	stdcmap->colormap = XCreateColormap(dpy, RootWindow(dpy, screen),
					    vinfo->visual, AllocNone);
    }
    stdcmap->red_max = red_max;
    stdcmap->green_max = green_max;
    stdcmap->blue_max = blue_max;
    if (property == XA_RGB_GRAY_MAP) 
	stdcmap->red_mult = stdcmap->green_mult = stdcmap->blue_mult = 1;
    else if (vinfo->class == TrueColor || vinfo->class == DirectColor) {
	stdcmap->red_mult = lowbit(vinfo->red_mask);
	stdcmap->green_mult = lowbit(vinfo->green_mask);
	stdcmap->blue_mult = lowbit(vinfo->blue_mask);
    } else {
	int red_pri, green_pri, blue_pri;

	/* There's probably a more clever way to do this.  */
	red_pri = (ramp_hint >> RAMP_SHIFT_RED) & 0xF;
	green_pri = (ramp_hint >> RAMP_SHIFT_GREEN) & 0xF;
	blue_pri = (ramp_hint >> RAMP_SHIFT_BLUE) & 0xF;
	if (red_pri == 2) {
	    stdcmap->red_mult = (red_max > 0)
		? (green_max + 1) * (blue_max + 1) : 0;
	    if (green_pri == 1) {
		stdcmap->green_mult = (green_max > 0) ? blue_max + 1 : 0;
		stdcmap->blue_mult = (blue_max > 0) ? 1 : 0;
	    }
	    else {
		stdcmap->blue_mult = (blue_max > 0) ? green_max + 1 : 0;
		stdcmap->green_mult = (green_max > 0) ? 1 : 0;
	    }
	}
	else if (red_pri == 1) {
	    if (green_pri == 2) {
		stdcmap->green_mult = (green_max > 0)
		    ? (red_max + 1) * (blue_max + 1) : 0;
		stdcmap->red_mult = (red_max > 0) ? blue_max + 1 : 0;
		stdcmap->blue_mult = (blue_max > 0) ? 1 : 0;
	    }
	    else {
		stdcmap->blue_mult = (blue_max > 0)
		    ? (red_max + 1) * (green_max + 1) : 0;
		stdcmap->red_mult = (red_max > 0) ? green_max + 1 : 0;
		stdcmap->green_mult = (green_max > 0) ? 1 : 0;
	    }
	}
	else {
	    stdcmap->red_mult = (red_max > 0) ? 1 : 0;
	    if (green_pri == 2) {
		stdcmap->green_mult = (green_max > 0)
		    ? (blue_max + 1) * (red_max + 1) : 0;
		stdcmap->blue_mult = (blue_max > 0) ? red_max + 1 : 0;
	    }
	    else {
		stdcmap->blue_mult = (blue_max > 0)
		    ? (green_max + 1) * (red_max + 1) : 0;
		stdcmap->green_mult = (green_max > 0) ? red_max + 1 : 0;
	    }
	}
    }
    stdcmap->base_pixel = 0;			/* base pixel may change */
    stdcmap->visualid = vinfo->visualid;

    status = 1;

#ifdef PEX_SUPPORT /* [ */
    /*
	Check the "proposed" ramp for PEX support.
	If there's a problem, the verifyPEXSupport() procedure includes
	vendor-specific code to attempt to fix it.
    */
    if (PEX_required) {


	status = verifyPEXSupport (dpy, vinfo, stdcmap, params, 
					&local_params, &allocated_params);
    }
#endif /* ] PEX_SUPPORT */


    /* Make the colormap */

    if (status) {

#ifdef PEX_SUPPORT /* [ */
	if (PEX_required) {
	    status = XmuCreateColormapExt(dpy, stdcmap, local_params);
	    if (allocated_params) 
		free((char *) local_params);
	}
	else
#endif /* ] PEX_SUPPORT */

	    status = XmuCreateColormapExt(dpy, stdcmap, params);
    }

    /* Clean up */

    XFree((char *) vinfo);
    if (!status) {

	/* Free the colormap or the pixmap, if we created one */
	if (stdcmap->killid == ReleaseByFreeingColormap)
	    XFreeColormap(dpy, stdcmap->colormap);
	else if (stdcmap->killid != None)
	    XFreePixmap(dpy, stdcmap->killid);
	
	XFree((char *) stdcmap);
	return (XStandardColormap *) NULL;
    }
    return stdcmap;
}

/****************************************************************************/
static Status valid_args(vinfo, red_max, green_max, blue_max, property)
    XVisualInfo		*vinfo;		/* specifies visual */
    unsigned long	red_max, green_max, blue_max;	/* specifies alloc */
    Atom		property;	/* specifies property name */
{
    unsigned long	ncolors;	/* number of colors requested */

    /* Determine that the number of colors requested is <= map size */

    if ((vinfo->class == DirectColor) || (vinfo->class == TrueColor)) {
	unsigned long mask;

	mask = vinfo->red_mask;
	while (!(mask & 1))
	    mask >>= 1;
	if (red_max > mask)
	    return 0;
	mask = vinfo->green_mask;
	while (!(mask & 1))
	    mask >>= 1;
	if (green_max > mask)
	    return 0;
	mask = vinfo->blue_mask;
	while (!(mask & 1))
	    mask >>= 1;
	if (blue_max > mask)
	    return 0;
    } else if (property == XA_RGB_GRAY_MAP) {
	ncolors = red_max + green_max + blue_max + 1;
	if (ncolors > vinfo->colormap_size)
	    return 0;
    } else {
	ncolors = (red_max + 1) * (green_max + 1) * (blue_max + 1);
	if (ncolors > vinfo->colormap_size)
	    return 0;
    }
    
    /* Determine that the allocation and visual make sense for the property */

    switch (property)
    {
      case XA_RGB_DEFAULT_MAP:
	if (red_max == 0 || green_max == 0 || blue_max == 0)
	    return 0;
	break;
      case XA_RGB_RED_MAP:
	if (red_max == 0)
	    return 0;
	break;
      case XA_RGB_GREEN_MAP:
	if (green_max == 0)
	    return 0;
	break;
      case XA_RGB_BLUE_MAP:	
	if (blue_max == 0)
	    return 0;
	break;
      case XA_RGB_BEST_MAP:
	if (red_max == 0 || green_max == 0 || blue_max == 0)
	    return 0;
	break;
      case XA_RGB_GRAY_MAP:
	if (red_max == 0 || blue_max == 0 || green_max == 0)
	    return 0;
	break;
      default:
	return 0;
    }
    return 1;
}


#ifdef PEX_SUPPORT /* [ */

static Status verifyPEXSupport (dpy, vinfo, stdcmap, params, new_params, alloc)
    Display		*dpy;
    XVisualInfo		*vinfo;
    XStandardColormap	*stdcmap;
    XmuExtendedParams	*params;
    XmuExtendedParams	**new_params;
    int			*alloc;
{
    int 		i;
    Status		status;
    Window		window;
    int			inquiry_supported;
    int			capx_supported;
    PEXExtensionInfo	*ext_info;
    PEXEscapeQueryColorApproxReplyData	*reply;

    *alloc = False;
    *new_params = NULL;

    if (NULL == (ext_info = PEXGetExtensionInfo (dpy)))
	return 0;

    /*
	Create a temporary unmapped window in the Visual.
    */

    if (!createTemporaryWindow (dpy, vinfo, &window))
	return 0;

    capx_supported = False;
    inquiry_supported = False;

    if ((ext_info->major_version == 5) &&
	(ext_info->minor_version >= 1)) 
    {
	int		enum_types[1];
	unsigned long 	*enum_count;
	PEXEnumTypeDesc	*enum_data;
	int		enum_index;

	/*
	    Verify that the QueryColorApprox escape is supported
	    using PEXGetEnumTypeInfo.  If not, we just can't verify
	    support, so we'll assume the color approximation entry is
	    supported.
	*/

	enum_types[0] = PEXETEscape;
	if (!PEXGetEnumTypeInfo (dpy, window, 1, enum_types, 
				PEXETIndex, &enum_count, &enum_data)) {

	    destroyTemporaryWindow (dpy, vinfo, window);
	    return 0;
	}
	else {

	    for (enum_index = 0; enum_index < *enum_count; enum_index++) {
		if ((short) enum_data[enum_index].index == 
		    (short) PEXETEscapeQueryColorApprox) {
		    inquiry_supported = True;
		    break;
		}
	    }
	    PEXFreeEnumInfo (1, enum_count, enum_data);
	}
    }

    if (inquiry_supported) {

	PEXEscapeQueryColorApproxData		query;
	unsigned long 				reply_length;

	/*
	    Load up the query structure from the property.
	*/

	query.capx.type = PEXColorSpace;
	query.capx.model = PEXColorApproxRGB;
	query.capx.dither = PEXOn;
	query.capx.base_pixel = stdcmap->base_pixel;
	query.capx.max1 = stdcmap->red_max;
	query.capx.max2 = stdcmap->green_max;
	query.capx.max3 = stdcmap->blue_max;
	query.capx.weight1 = 0.0;
	query.capx.weight2 = 0.0;
	query.capx.weight3 = 0.0;
	query.capx.mult1 = stdcmap->red_mult;
	query.capx.mult2 = stdcmap->green_mult;
	query.capx.mult3 = stdcmap->blue_mult;

	query.drawable = window;

	reply = (PEXEscapeQueryColorApproxReplyData *)
		PEXEscapeWithReply (dpy, PEXEscapeQueryColorApprox, 
				    sizeof(query), ((char *) &query), 
				    &reply_length);

	if (reply != NULL) {

	    capx_supported = (reply->capx_is_supported);
	}
	else {
	    destroyTemporaryWindow (dpy, vinfo, window);
	    return 0;
	}
    }
    else {
	/* Can't determine support or non-support. */
	capx_supported = True;
    }

    /*
	If the ramp as "proposed" isn't supported, make adjustments.
    */

    if (!capx_supported) {

	/*
	    These vendors have verified that the "else" clause in
	    the following if-then-else cascade is adequate for their
	    implementations.  If a particular vendor has needs that are
	    not met by the common "else" section, an "if" section should
	    be added for that vendor before the common "else" (see the
	    commented-out example below).
	*/

	/*
	if (!strcmp(ext_info->vendor_name, "vendor_X")) {
	}
	else 
	*/

	{
	    XmuExtendedParams 	*local_params;
	    XmuParam 		*src_ptr, *dst_ptr;
	    PEXColorApproxEntry *p_capx;

	    /* Assuming inquiry is supported, so reply exists */
	    if (reply->count) {
		p_capx = (PEXColorApproxEntry *) (((char *) reply) + 
			    sizeof(PEXEscapeQueryColorApproxReplyData));

		/* search for the best match, here, maybe, someday 
		if (reply->count > 1) {
		}
		*/

		/* copy chosen entry into stdcmap */
		stdcmap->base_pixel = p_capx->base_pixel;
		stdcmap->red_max = p_capx->max1;
		stdcmap->green_max = p_capx->max2;
		stdcmap->blue_max = p_capx->max3;
		stdcmap->red_mult = p_capx->mult1;
		stdcmap->green_mult = p_capx->mult2;
		stdcmap->blue_mult = p_capx->mult3;

		/* add control for base pixel */
		local_params = (XmuExtendedParams *)
				malloc ((sizeof(XmuExtendedParams) +
					(1 + params->num_controls + 
					params->num_hints) * 
					sizeof(XmuParam)));
		if (local_params == NULL) {
		    XFree ((char *) reply);
		    return 0;
		}

		*alloc = True;
		*new_params = local_params;
		src_ptr = (XmuParam *) (((char *) params) +
					sizeof(XmuExtendedParams));
		dst_ptr = (XmuParam *) (((char *) local_params) +
					sizeof(XmuExtendedParams));

		local_params->num_controls = params->num_controls+1;
		local_params->controls = dst_ptr;
		for (i=0; i<params->num_controls; i++) {
		    *dst_ptr = *src_ptr;
		    dst_ptr++;
		    src_ptr++;
		}
		dst_ptr->name = XMU_CONTROL_BASE_PIXEL;
		dst_ptr->value = p_capx->base_pixel;
		dst_ptr++;

		local_params->num_hints = params->num_hints;
		for (i=0; i<params->num_hints; i++) {
		    *dst_ptr = *src_ptr;
		    dst_ptr++;
		    src_ptr++;
		}
	    }
	    else {
		/* don't know what to try */
		XFree ((char *) reply);
		return 0;
	    }
	}
    }
    else {
	*alloc = False;
	*new_params = params;
    }

    if (inquiry_supported)
	XFree ((char *) reply);

    /*
	Destroy the temporary window.
    */
    destroyTemporaryWindow (dpy, vinfo, window);

    return 1;
}


static Status createTemporaryWindow (display, vis_info, window_return)
    Display	*display;
    XVisualInfo	*vis_info;
    Window	*window_return;
{
    unsigned long 		window_mask;
    XSetWindowAttributes	window_attrs;
    Colormap			cmap_id;


    /*
	Create a window using override-redirect.  Do not map it.
	If the Visual is the default, use the root window.
	Otherwise, create a colormap to use.
    */

    if (vis_info->visual == DefaultVisual (display, vis_info->screen)) {

	*window_return = RootWindow (display, vis_info->screen);
	return 1;
    }
    else {
	cmap_id = XCreateColormap (display, 
				    RootWindow(display, vis_info->screen),
				    vis_info->visual, AllocNone );
	if (cmap_id == None)
	    return 0;

	window_attrs.colormap = cmap_id;
	window_mask = CWColormap;

	window_attrs.override_redirect = True;
	window_mask |= CWOverrideRedirect;

	window_attrs.background_pixel = 0;
	window_mask |= CWBackPixel;

	window_attrs.border_pixel = 0;
	window_mask |= CWBorderPixel;

	*window_return = XCreateWindow (display, 
				RootWindow (display, vis_info->screen),
				10, 10, 1, 1, 0,
				vis_info->depth, 
				InputOutput,
				vis_info->visual,
				window_mask,
				&(window_attrs));

	if (*window_return == None)
	    return 0;
	else
	    return 1;
    }
} /* createTemporaryWindow */


static Status destroyTemporaryWindow (display, vis_info, window)
    Display	*display;
    XVisualInfo	*vis_info;
    Window	window;
{
    XWindowAttributes	window_attrs;

    /*
	If this window is not in the default Visual, 
	the Colormap and Window need to be freed.
    */

    if (vis_info->visual != DefaultVisual (display, vis_info->screen)) {

	if (XGetWindowAttributes (display, window, &window_attrs))
	    XFreeColormap (display, window_attrs.colormap);

	XDestroyWindow (display, window);
    }

    return 1;

} /* destroyTemporaryWindow */

#endif /* ] PEX_SUPPORT */
