/* $XConsortium: VisCmap.c,v 1.10 89/10/08 15:05:47 rws Exp $ 
 * 
 * Copyright 1989 by the Massachusetts Institute of Technology
 *
 * Permission to use, copy, modify, and distribute this software and its
 * documentation for any purpose and without fee is hereby granted, provided 
 * that the above copyright notice appear in all copies and that both that 
 * copyright notice and this permission notice appear in supporting 
 * documentation, and that the name of M.I.T. not be used in advertising
 * or publicity pertaining to distribution of the software without specific, 
 * written prior permission. M.I.T. makes no representations about the 
 * suitability of this software for any purpose.  It is provided "as is"
 * without express or implied warranty.
 *
 * M.I.T. DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING ALL
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL M.I.T.
 * BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
 * WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION
 * OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN
 * CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
 *
 * Author:  Donna Converse, MIT X Consortium
 *                                                                            
 *                                                                            
 *                                                                            
 *  (c) Copyright Hewlett-Packard Company, 1993, Fort Collins, Colorado       
 *                                                                            
 *                            All Rights Reserved                             
 *                                                                            
 *  Permission to use, copy, modify, and distribute this software and its     
 *  documentation for any purpose and without fee is hereby granted,          
 *  provided that the above copyright notices appear in all copies and that   
 *  both the copyright notices and this permission notice appear in           
 *  supporting documentation, and that the name of Hewlett-Packard not be     
 *  used in advertising or publicity pertaining to distribution of the        
 *  software without specific, written prior permission.                      
 *                                                                            
 *  HEWLETT-PACKARD MAKES NO WARRANTY OF ANY KIND WITH REGARD TO THIS         
 *  SOFTWARE, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF        
 *  MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.  Hewlett-Packard    
 *  shall not be liable for errors contained herein or direct, indirect,      
 *  special, incidental or consequential damages in connection with the       
 *  furnishing, performance or use of this software.                          
 *
 * Modifications for PEX:  John Waitz, Hewlett-Packard Company
 *
 */

#include <stdio.h>
#include <math.h>
#include <X11/Xlib.h>
#include <X11/Xatom.h>
#include <X11/Xutil.h>
#include <X11/Xmu/StdCmap.h>
#include <X11/Xmu/StdCmapExt.h>
#ifdef PEX_SUPPORT /* [ */
#include <X11/PEX5/PEXlib.h>
#endif /* ] PEX_SUPPORT */

/*
 * To create all of the appropriate standard colormaps for a given visual on
 * a given screen, use XmuVisualStandardColormapsExt().
 * 
 * Define all appropriate standard colormap properties for the given visual.
 * If replace is true, any previous definition will be removed.
 * If retain is true, new properties will be retained for the duration of
 * the server session.  Return 0 on failure, non-zero on success.
 * On failure, no new properties will be defined, and, old ones may have
 * been removed if replace was True.
 *
 * Not all standard colormaps are meaningful to all visual classes.  This
 * routine will check and define the following properties for the following
 * classes, provided that the size of the colormap is not too small.
 *
 *	DirectColor and PseudoColor
 *	    RGB_DEFAULT_MAP
 *	    RGB_BEST_MAP
 *	    RGB_RED_MAP
 *	    RGB_GREEN_MAP
 * 	    RGB_BLUE_MAP
 *          RGB_GRAY_MAP
 *
 *	TrueColor and StaticColor
 *	    RGB_BEST_MAP
 *	    if PEX support required, RGB_DEFAULT_MAP
 *
 *	GrayScale
 *	    RGB_DEFAULT_MAP
 *	    RGB_GRAY_MAP
 *
 *	StaticGray
 *	    RGB_GRAY_MAP
 */

Status XmuVisualStandardColormapsExt(dpy, screen, visualid, depth, replace,
				  retain, params)
    Display		*dpy;		/* specifies server connection */
    int			screen;		/* specifies screen number */
    VisualID		visualid;	/* specifies the visual */
    unsigned int	depth;		/* specifies the visual */
    Bool		replace;	/* specifies whether to replace */
    Bool		retain;		/* specifies whether to retain */
    XmuExtendedParams 	*params;	/* controls and hints */
{
    Status		status;
    int			n;
    long		vinfo_mask;
    XVisualInfo		vinfo_template, *vinfo;
#ifdef PEX_SUPPORT /* [ */
    int			PEX_required = False;
#endif /* ] PEX_SUPPORT */

    /*
	Decode controls and hints supported in this procedure.
    */
#ifdef PEX_SUPPORT /* [ */
    if (params) {
	int i;
	for (i=0; i < params->num_controls; i++) {
	    if (params->controls[i].name == XMU_CONTROL_PEX_SUPPORTED)
		PEX_required = params->controls[i].value;
	}
    }
#endif /* ] PEX_SUPPORT */
        
    vinfo_template.screen = screen;
    vinfo_template.visualid = visualid;
    vinfo_template.depth = depth;
    vinfo_mask = VisualScreenMask | VisualIDMask | VisualDepthMask;
    if ((vinfo = XGetVisualInfo(dpy, vinfo_mask, &vinfo_template, &n)) == NULL)
	return 0;

    if (vinfo->colormap_size <= 2) {
	/* Monochrome visuals have no standard maps; considered successful */
	XFree((char *) vinfo);
	return 1;
    }

#ifdef PEX_SUPPORT /* [ */
    /*
	If PEX is required, check support for the Visual.
    */
    if (PEX_required) {

	PEXExtensionInfo	*ext_info;
	PEXRenderingTarget	*targets;
	unsigned long		target_count;

	targets = NULL;
	target_count = 0;

	if (NULL == (ext_info = PEXGetExtensionInfo (dpy)))
	    return 0;

	if ((ext_info->major_version == 5) &&
	    (ext_info->minor_version >= 1)) {

	    if ((! PEXMatchRenderingTargets (dpy, 
					RootWindow(dpy, screen),
					depth, PEXWindowDrawable, vinfo->visual,
					1, &target_count, &targets)) ||
		(target_count == 0)) {
		XFree((char *) vinfo);
		return 0;
	    }

	    XFree (targets);
	}
    }
#endif /* ] PEX_SUPPORT */

    switch (vinfo->class)
    {
      case PseudoColor:
      case DirectColor:
	status = XmuLookupStandardColormapExt(dpy, screen, visualid, depth,
					   XA_RGB_DEFAULT_MAP, replace,retain,
					   params);
	if (!status) break;

	status = XmuLookupStandardColormapExt(dpy, screen, visualid, depth,
					   XA_RGB_GRAY_MAP, replace, retain,
					   params);
	if (!status) {
	    XmuDeleteStandardColormap(dpy, screen, XA_RGB_DEFAULT_MAP);
	    break;
	}

	status = XmuLookupStandardColormapExt(dpy, screen, visualid, depth,
					   XA_RGB_RED_MAP, replace, retain,
					   params);
	if (!status) {
	    XmuDeleteStandardColormap(dpy, screen, XA_RGB_DEFAULT_MAP);
	    XmuDeleteStandardColormap(dpy, screen, XA_RGB_GRAY_MAP);
	    break;
	}

	status = XmuLookupStandardColormapExt(dpy, screen, visualid, depth,
					   XA_RGB_GREEN_MAP, replace, retain,
					   params);
	if (!status) {
	    XmuDeleteStandardColormap(dpy, screen, XA_RGB_DEFAULT_MAP);
	    XmuDeleteStandardColormap(dpy, screen, XA_RGB_GRAY_MAP);
	    XmuDeleteStandardColormap(dpy, screen, XA_RGB_RED_MAP);
	    break;
	}

	status = XmuLookupStandardColormapExt(dpy, screen, visualid, depth,
					   XA_RGB_BLUE_MAP, replace, retain,
					   params);
	if (!status) {
	    XmuDeleteStandardColormap(dpy, screen, XA_RGB_DEFAULT_MAP);
	    XmuDeleteStandardColormap(dpy, screen, XA_RGB_GRAY_MAP);
	    XmuDeleteStandardColormap(dpy, screen, XA_RGB_RED_MAP);
	    XmuDeleteStandardColormap(dpy, screen, XA_RGB_GREEN_MAP);
	    break;
	}
	/* fall through */

      case StaticColor:
      case TrueColor:

#ifdef PEX_SUPPORT /* [ */
	if (PEX_required &&
	    ((vinfo->class == TrueColor) || (vinfo->class == StaticColor))) {

	    status = XmuLookupStandardColormapExt(dpy, screen, visualid, depth,
					   XA_RGB_DEFAULT_MAP, replace,retain,
					   params);
	    if (!status) break;
	}
#endif /* ] PEX_SUPPORT */

	status = XmuLookupStandardColormapExt(dpy, screen, visualid, depth,
					   XA_RGB_BEST_MAP, replace, retain,
					   params);

	if (!status) {
	    if (vinfo->class == PseudoColor || 
		vinfo->class == DirectColor) {
		XmuDeleteStandardColormap(dpy, screen, XA_RGB_DEFAULT_MAP);
		XmuDeleteStandardColormap(dpy, screen, XA_RGB_GRAY_MAP);
		XmuDeleteStandardColormap(dpy, screen, XA_RGB_RED_MAP);
		XmuDeleteStandardColormap(dpy, screen, XA_RGB_GREEN_MAP);
		XmuDeleteStandardColormap(dpy, screen, XA_RGB_BLUE_MAP);
	    }
	    else {
		XmuDeleteStandardColormap(dpy, screen, XA_RGB_DEFAULT_MAP);
	    }
	}
	break;
	/* the end for PseudoColor, DirectColor, StaticColor, and TrueColor */

      case GrayScale:
	status = XmuLookupStandardColormapExt(dpy, screen, visualid, depth,
					   XA_RGB_DEFAULT_MAP, replace,
					   retain, params);
	if (! status) break;
	/* fall through */

      case StaticGray:

	status = XmuLookupStandardColormapExt(dpy, screen, visualid, depth,
					   XA_RGB_GRAY_MAP, replace, retain,
					   params);
	if (! status && vinfo->class == GrayScale) {
	    XmuDeleteStandardColormap(dpy, screen, XA_RGB_DEFAULT_MAP);
	    break;
	}
    }

    XFree((char *) vinfo);
    return status;
}
