/* $XConsortium: StdCmapExt.h,v 1.3 91/07/22 23:46:03 converse Exp $
 *
 * Copyright 1991 by the Massachusetts Institute of Technology
 *
 * Permission to use, copy, modify, and distribute this software and its
 * documentation for any purpose and without fee is hereby granted, provided 
 * that the above copyright notice appear in all copies and that both that 
 * copyright notice and this permission notice appear in supporting 
 * documentation, and that the name of M.I.T. not be used in advertising
 * or publicity pertaining to distribution of the software without specific, 
 * written prior permission. M.I.T. makes no representations about the 
 * suitability of this software for any purpose.  It is provided "as is"
 * without express or implied warranty.
 *
 * The X Window System is a Trademark of MIT.
 *
 * The interfaces described by this header file are for miscellaneous utilities
 * and are not part of the Xlib standard.
 *
 *                                                                            
 *                                                                            
 *                                                                            
 *  (c) Copyright Hewlett-Packard Company, 1993, Fort Collins, Colorado       
 *                                                                            
 *                            All Rights Reserved                             
 *                                                                            
 *  Permission to use, copy, modify, and distribute this software and its     
 *  documentation for any purpose and without fee is hereby granted,          
 *  provided that the above copyright notices appear in all copies and that   
 *  both the copyright notices and this permission notice appear in           
 *  supporting documentation, and that the name of Hewlett-Packard not be     
 *  used in advertising or publicity pertaining to distribution of the        
 *  software without specific, written prior permission.                      
 *                                                                            
 *  HEWLETT-PACKARD MAKES NO WARRANTY OF ANY KIND WITH REGARD TO THIS         
 *  SOFTWARE, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF        
 *  MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.  Hewlett-Packard    
 *  shall not be liable for errors contained herein or direct, indirect,      
 *  special, incidental or consequential damages in connection with the       
 *  furnishing, performance or use of this software.                          
 *
 * Modifications for PEX:  John Waitz, Hewlett-Packard Company
 *
 */

#ifndef _XMU_STDCMAPEXT_H_
#define _XMU_STDCMAPEXT_H_

#include <X11/Xfuncproto.h>

typedef struct {
    unsigned int	name;
    unsigned int	value;
} XmuParam;

typedef struct {
    unsigned int	num_controls;
    XmuParam		*controls;
    unsigned int	num_hints;
    XmuParam		*hints;
} XmuExtendedParams;

/*
	Supported controls and hints.
*/
#define	XMU_CONTROL_BASE_PIXEL		0x00000001
#define NOT_DETERMINED			0xFFFFFFFF

#ifdef PEX_SUPPORT /* [ */
#define XMU_CONTROL_PEX_SUPPORTED	0x00000002
#endif /* ] PEX_SUPPORT */

#define XMU_HINT_PSEUDO_RAMP		0x01000001
#define RAMP_RGB			0x00000210
#define RAMP_GBR			0x00000021
#define RAMP_BRG			0x00000102
#define RAMP_BGR			0x00000012
#define RAMP_RBG			0x00000201
#define RAMP_GRB			0x00000120
#define RAMP_SHIFT_RED			8
#define RAMP_SHIFT_GREEN		4
#define RAMP_SHIFT_BLUE			0

#define XMU_HINT_CREATE_DEFAULT		0x01000002

_XFUNCPROTOBEGIN

Status XmuAllStandardColormapsExt(
#if NeedFunctionPrototypes
    Display*		/* dpy */,
    XmuExtendedParams*	/* controls and hints */
#endif
);

Status XmuCreateColormapExt(
#if NeedFunctionPrototypes
    Display*		/* dpy */,
    XStandardColormap*	/* colormap */,
    XmuExtendedParams*	/* controls and hints */
#endif
);

Status XmuGetColormapAllocationExt(
#if NeedFunctionPrototypes
    XVisualInfo*	/* vinfo */,
    Atom		/* property */,
    XmuExtendedParams*	/* controls and hints */,
    unsigned long*	/* red_max_return */,
    unsigned long*	/* green_max_return */,
    unsigned long*	/* blue_max_return */
#endif
);

Status XmuLookupStandardColormapExt(
#if NeedFunctionPrototypes
    Display*		/* dpy */,
    int			/* screen */,
    VisualID		/* visualid */,
    unsigned int	/* depth */,
    Atom		/* property */,
    Bool		/* replace */,
    Bool		/* retain */,
    XmuExtendedParams*	/* controls and hints */
#endif
);

XStandardColormap *XmuStandardColormapExt(
#if NeedFunctionPrototypes
    Display*		/* dpy */,
    int			/* screen */,
    VisualID		/* visualid */,
    unsigned int	/* depth */,
    Atom		/* property */,
    Colormap		/* cmap */,
    unsigned long	/* red_max */,
    unsigned long	/* green_max */,
    unsigned long	/* blue_max */,
    XmuExtendedParams*	/* controls and hints */
#endif
);

Status XmuVisualStandardColormapsExt(
#if NeedFunctionPrototypes
    Display*		/* dpy */,
    int			/* screen */,
    VisualID		/* visualid */,
    unsigned int	/* depth */,
    Bool		/* replace */,
    Bool		/* retain */,
    XmuExtendedParams*	/* controls and hints */
#endif
);

_XFUNCPROTOEND

#endif /* _XMU_STDCMAPEXT_H_ */
