
/*
******************************************************************************
** Color configuration inquiry 
**
** $Source: /XTesting.src/XSystem/pex/color/RCS/colorinq.c,v $
** $Revision: 1.7 $
** $Date: 92/11/25 21:20:53 $
** $Author: waitz $
** $State: Exp $
******************************************************************************
*/

/*      
 *                                                                            
 *                                                                            
 *  (c) Copyright Hewlett-Packard Company, 1993, Fort Collins, Colorado       
 *                                                                            
 *                            All Rights Reserved                             
 *                                                                            
 *  Permission to use, copy, modify, and distribute this software and its     
 *  documentation for any purpose and without fee is hereby granted,          
 *  provided that the above copyright notices appear in all copies and that   
 *  both the copyright notices and this permission notice appear in           
 *  supporting documentation, and that the name of Hewlett-Packard not be     
 *  used in advertising or publicity pertaining to distribution of the        
 *  software without specific, written prior permission.                      
 *                                                                            
 *  HEWLETT-PACKARD MAKES NO WARRANTY OF ANY KIND WITH REGARD TO THIS         
 *  SOFTWARE, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF        
 *  MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.  Hewlett-Packard    
 *  shall not be liable for errors contained herein or direct, indirect,      
 *  special, incidental or consequential damages in connection with the       
 *  furnishing, performance or use of this software.                          
 *
 */


#include <stdio.h>
#include <string.h>

#include <X11/X.h>
#include <X11/Xlib.h>
#include <X11/Xutil.h>
#include <X11/Xatom.h>
#include <X11/PEX5/PEXlib.h>

#define STREAM stdout

static Atom cmap_prop_atoms[] = {
	XA_RGB_DEFAULT_MAP,
	XA_RGB_BEST_MAP,
	XA_RGB_RED_MAP,
	XA_RGB_GREEN_MAP,
	XA_RGB_BLUE_MAP,
	XA_RGB_GRAY_MAP,
};
#define NUM_CMAP_PROPS (sizeof(cmap_prop_atoms)/sizeof(Atom))

static char *cmap_prop_names[NUM_CMAP_PROPS];
static XStandardColormap *cmap_prop_data[NUM_CMAP_PROPS];
static int cmap_entry_counts[NUM_CMAP_PROPS];


/*
	This is the struct type for SERVER_OVERLAY_VISUALS property.
*/
typedef struct
{
    VisualID 	visualid;        /* The Visual ID of the overlay visual */
    int      	transparentType; /* None, TransparentPixel, TransparentMask */
    int      	value;           /* Pixel value */
    int      	layer;           /* Overlay planes will be in layer 1 */
} HPOverlayProperty;


static int enum_types[]={
	PEXETColorApproxType,
	PEXETColorApproxModel,
};
#define NUM_ENUM_TYPES (sizeof(enum_types)/sizeof(int))

static char *enum_names[NUM_ENUM_TYPES]={
	"Color approximation type",
	"Color approximation model",
};


static unsigned short imp_dep_constants[]={
	PEXIDBestColorApprox,
	PEXIDDitheringSupported,
};
#define NUM_CONSTANTS (sizeof(imp_dep_constants)/sizeof(unsigned short))

static char *constant_names[NUM_CONSTANTS]={
	"BestColorApprox",
	"DitheringSupported"
};


/*
	This is the structure for recording information about a visual.
*/
typedef struct {
	VisualID 			visualid;
	unsigned int		depth;
	int					class;
	int 				is_overlay;
	int 				pex_supported;
	XStandardColormap 	*cmap_prop_entries[NUM_CMAP_PROPS];
	XStandardColormap 	*pex_best_map_entry;
	PEXEnumTypeDesc		*enum_values[NUM_ENUM_TYPES];
	int					enum_counts[NUM_ENUM_TYPES];
	PEXImpDepConstant	constants[NUM_CONSTANTS];
	int					predefined_approx_count;
	PEXColorApproxEntry *predefined_approx_entries;
	int					predefined_color_count;
} report_data;


static struct _color_approx_model_map {
	int approx_model;
	char *approx_model_name;
} color_approx_model_names[]={
	{ PEXColorApproxRGB, 	PEXETMColorApproxRGB },
	{ PEXColorApproxCIE, 	PEXETMColorApproxCIE },
	{ PEXColorApproxHSV, 	PEXETMColorApproxHSV },
	{ PEXColorApproxHLS, 	PEXETMColorApproxHLS },
	{ PEXColorApproxYIQ, 	PEXETMColorApproxYIQ },
};
#define NUM_COLOR_APPROX_MODEL_NAMES (sizeof(color_approx_model_names)/sizeof(struct _color_approx_model_map))

static struct _best_color_approx_map {
	int value;
	char *name;
} best_color_approx_names[]={
	{ PEXColorApproxPowersOf2, 	"PEXColorApproxPowersOf2" },
	{ PEXColorApproxAnyValues, 	"PEXColorApproxAnyValues" },
};
#define NUM_BEST_COLOR_APPROX_NAMES (sizeof(best_color_approx_names)/sizeof(struct _best_color_approx_map))

static struct _visual_class_map {
	int class;
	char *class_name;
} visual_class_names[]={
	{ StaticGray, 	"StaticGray" },
	{ GrayScale, 	"GrayScale" },
	{ StaticColor, 	"StaticColor" },
	{ PseudoColor, 	"PseudoColor" },
	{ TrueColor, 	"TrueColor" },
	{ DirectColor, 	"DirectColor" },
};
#define NUM_VISUAL_CLASSES (sizeof(visual_class_names)/sizeof(struct _visual_class_map))


void dump_colorapprox_entry (PEXColorApproxEntry *source)
{
	char *type_string, *model_string;
	int i;

	if (source->type == PEXColorSpace) 
		type_string = PEXETMColorSpace;
	else if (source->type == PEXColorRange) 
		type_string = PEXETMColorRange;
	else
		type_string = "Unsupported type";

	model_string = "Unrecognized model";
	for (i=0; i<NUM_COLOR_APPROX_MODEL_NAMES; i++) {
		if (color_approx_model_names[i].approx_model == source->model) {
			model_string = color_approx_model_names[i].approx_model_name;
			break;
		}
	}

	fprintf (STREAM, "\t\ttype: %s\n", type_string);
	fprintf (STREAM, "\t\tmodel: %s\n", model_string);
	fprintf (STREAM, "\t\tmax1: %d\n", source->max1);
	fprintf (STREAM, "\t\tmax2: %d\n", source->max2);
	fprintf (STREAM, "\t\tmax3: %d\n", source->max3);
	fprintf (STREAM, "\t\tdither: %d\n", source->dither);
	fprintf (STREAM, "\t\tmult1: %d\n", source->mult1);
	fprintf (STREAM, "\t\tmult2: %d\n", source->mult2);
	fprintf (STREAM, "\t\tmult3: %d\n", source->mult3);
	fprintf (STREAM, "\t\tweight1: %f\n", source->weight1);
	fprintf (STREAM, "\t\tweight2: %f\n", source->weight2);
	fprintf (STREAM, "\t\tweight3: %f\n", source->weight3);
	fprintf (STREAM, "\t\tbase_pixel: %d\n", source->base_pixel);
}

void dump_std_colormap (XStandardColormap *source)
{
	if (source->colormap != None)
		fprintf (STREAM, "\t\tcolormap: 0x%x\n", source->colormap);
	else
		fprintf (STREAM, "\t\tcolormap: not defined\n");

	fprintf (STREAM, "\t\tred_max: %d\n", source->red_max);
	fprintf (STREAM, "\t\tred_mult: %d\n", source->red_mult);
	fprintf (STREAM, "\t\tgreen_max: %d\n", source->green_max);
	fprintf (STREAM, "\t\tgreen_mult: %d\n", source->green_mult);
	fprintf (STREAM, "\t\tblue_max: %d\n", source->blue_max);
	fprintf (STREAM, "\t\tblue_mult: %d\n", source->blue_mult);
	fprintf (STREAM, "\t\tbase_pixel: %d\n", source->base_pixel);

	fprintf (STREAM, "\t\tvisualid: 0x%x\n", source->visualid);
	fprintf (STREAM, "\t\tkillid: 0x%x\n", source->killid);
}


main(argc, argv)
int argc;
char **argv;
{
	Display 			*display;
	Window 				window;
	Colormap			colormap;
	PEXExtensionInfo 	*ext_info;
	XVisualInfo 		vis_info;

	int					screen_count;
	int 				screen;
	Screen				*screen_ptr;

	int					*depth_return;
	int					depth_count;

	PEXTableInfo		lut_info;

    XVisualInfo       	*visuals;
    int     		  	num_visuals;
    XVisualInfo       	vis_templ;
    unsigned int      	vis_mask;

	Atom	    		envarAtom;
	unsigned long   	nLongs, nItems, nBytesUnread;
	int					nBytes;
    Atom              	actualType;
    int               	actualFormat;
	int					retVal;

    HPOverlayProperty 	*ovl_visuals = NULL;
    int               	num_ovl_visuals = 0;
    XStandardColormap	*pex_best_map = NULL;
    int					num_pex_best_map_entries = 0;
    XStandardColormap	*cmap_ptr;

	Atom				*atoms;
	int					num_atoms;
	char				*property_name;

	unsigned long		num_targets = 0;
	PEXRenderingTarget	*target_data = NULL;

    unsigned long		*enum_counts = NULL;
    PEXEnumTypeDesc		*enum_values = NULL;
    PEXEnumTypeDesc		*value_ptr;
	PEXImpDepConstant	*constants = NULL;

	report_data			report;
	char				*class_name;
	char				*best_color_approx_name;

	int 				i, k, vis_index;
	char				error_string[256];
	int					result;

	int					pex_is_supported;

	unsigned long 			window_mask;
	XSetWindowAttributes 	window_attrs;


	/*
		Initialize X and PEX.
	*/

	if (NULL == (display = XOpenDisplay (NULL))) {

		fprintf (stderr, "PROCESS ERROR:  XOpenDisplay failed on %s\n", 
								getenv("DISPLAY"));
		exit (1);
	}

	if (PEXInitialize (display, &ext_info, 256, error_string))
	{
		fprintf (stderr, "NOTE:  PEXInitialize failed on %s\n", 
								getenv("DISPLAY"));
		fprintf (stderr, "\t%s\n", error_string);
		pex_is_supported = False;
	}
	else
		pex_is_supported = True;


	/*
		Get names for the standard properties outside any loops.
	*/

	for (i=0; i<NUM_CMAP_PROPS; i++)
		cmap_prop_names[i] = XGetAtomName (display, cmap_prop_atoms[i]);


	/*
		Get and print some general information about the server.
	*/

	fprintf (STREAM, "Vendor: %s\n", ServerVendor(display));
	fprintf (STREAM, "Release: %d\n", VendorRelease(display));

	screen_count = ScreenCount (display);
	fprintf (STREAM, "Screen count: %d\n", screen_count);
    screen = DefaultScreen (display);
    fprintf (STREAM, "Default screen is %d\n", screen);

	for (screen = 0; screen < screen_count; screen++) {

		fprintf (STREAM, "===============================\n");
		fprintf (STREAM, "Screen number: %d\n", screen);
		fprintf (STREAM, "\n");

		screen_ptr = ScreenOfDisplay (display, screen);

		fprintf (STREAM, "  Default depth is %d\n", 
				DefaultDepthOfScreen(screen_ptr));
		fprintf (STREAM, "  Default visualid is 0x%x\n", 
				XVisualIDFromVisual(DefaultVisualOfScreen(screen_ptr)));
		fprintf (STREAM, "  Default colormap is 0x%x\n",
				DefaultColormapOfScreen(screen_ptr));
		fprintf (STREAM, "  Max installed colormap count is %d\n",
				MaxCmapsOfScreen(screen_ptr));
		fprintf (STREAM, "  Min installed colormap count is %d\n",
				MinCmapsOfScreen(screen_ptr));
		

		/*
			Get information about all the properties and 
			visuals on the screen.
		*/

		fprintf (STREAM, "  Root window properties: \n");
		atoms = XListProperties (display, RootWindow(display, screen),
				&num_atoms);
		if (atoms == NULL)
			fprintf (STREAM, "    list properties failed\n");
		else {
			for (i=0; i<num_atoms; i++) {
				property_name = XGetAtomName (display, atoms[i]);
				fprintf (STREAM, "    %5d:\t%s\n", atoms[i], property_name);
				XFree (property_name);
			}
			XFree (atoms);
		}


		fprintf (STREAM, "  Depths available: ");
		depth_return = XListDepths (display, screen, &depth_count);
		if (depth_return == NULL)
			fprintf (STREAM, "inquiry failed\n");
		else {
			for (i=0; i<depth_count; i++)
				fprintf (STREAM, "%d, ", depth_return[i]);
			XFree (depth_return);
		}
		fprintf (STREAM, "\n");

			
		vis_templ.screen = screen;
		vis_mask = VisualScreenMask;

		if (NULL == (visuals = XGetVisualInfo(display, 
										vis_mask, &vis_templ, &num_visuals))) {
			fprintf (STREAM, "ERROR: No visual information for the screen.\n");
			continue;
		}
		else {
			fprintf (STREAM, "  Number of Visuals: %d\n", num_visuals);
			fprintf (STREAM, "\n");
		}


		if (envarAtom = XInternAtom(display,"SERVER_OVERLAY_VISUALS",True))
		{
			nBytesUnread = 0;
			nLongs = sizeof(HPOverlayProperty)/4;
			do
			{
				nLongs += (nBytesUnread+3)/4;
				XGetWindowProperty(display,RootWindow(display,screen),
					envarAtom, 0, nLongs, False, envarAtom, &actualType,
					&actualFormat, &nItems, &nBytesUnread,
					(unsigned char **)&ovl_visuals);
			} while (nBytesUnread > 0);

			num_ovl_visuals = nItems/(sizeof(HPOverlayProperty)/4);
		}
		else /* screen has no overlay visuals property */
		{
			fprintf (STREAM, 
				"  NOTE: SERVER_OVERLAY_VISUALS property inquiry failed\n");
			ovl_visuals = (HPOverlayProperty *) NULL;
			num_ovl_visuals = 0;
		}
		fprintf (STREAM, "\n");


		/*
			Get the values of all the standard colormap properties.
		*/

		for (i=0; i<NUM_CMAP_PROPS; i++) {

			fprintf (STREAM,
				"  Standard colormap property %s:\n", cmap_prop_names[i]);

			result = XGetRGBColormaps (display, RootWindow(display,screen),
					&(cmap_prop_data[i]), 
					&(cmap_entry_counts[i]), 
					cmap_prop_atoms[i]);

			if (!result) {
				fprintf (STREAM, "\tinquiry failed\n");
				cmap_prop_data[i] = NULL;
				cmap_entry_counts[i] = 0;
			}
			else {

				cmap_ptr = cmap_prop_data[i];
				for (k=0; k<cmap_entry_counts[i]; k++) {

					fprintf (STREAM, "  entry number %d\n", k);
					dump_std_colormap (cmap_ptr);
					fprintf (STREAM, "\n");
					cmap_ptr++;
				}
			}
			fprintf (STREAM, "\n");
		}


#ifdef NEVER
		/*
			Get the value of the proposed colormap property, PEX_BEST_MAP.
		*/

		if (envarAtom = XInternAtom(display, "PEX_BEST_MAP", True)) {

			fprintf (STREAM,
				"  Property atom %d: %s\n", envarAtom, "PEX_BEST_MAP");

			nBytesUnread = 0;
			nLongs = num_visuals * sizeof(XStandardColormap)/4;
			do {
				nLongs += (nBytesUnread+3)/4;
				retVal = XGetWindowProperty (display, 
					RootWindow(display,screen),
					envarAtom, 0, nLongs, False, envarAtom, 
					&actualType, &actualFormat, &nItems, &nBytesUnread,
					(unsigned char **) &pex_best_map);

			} while ((retVal == Success) && (nBytesUnread > 0));

			if (retVal != Success) {
				fprintf (STREAM, "\tinquiry failed\n");
				num_pex_best_map_entries = 0;
				pex_best_map = (XStandardColormap *) NULL;
			}
			else {
				num_pex_best_map_entries = nItems/(sizeof(XStandardColormap)/4);

				cmap_ptr = pex_best_map;
				for (k=0; k<num_pex_best_map_entries; k++) {

					fprintf (STREAM, "  entry number %d\n", k);
					dump_std_colormap (cmap_ptr);
					fprintf (STREAM, "\n");
					cmap_ptr++;
				}
			}
		}
		else /* PEX_BEST_MAP not defined */
		{
			fprintf (STREAM,
					"  Property atom %d: %s\n", 0, "PEX_BEST_MAP");
			fprintf (STREAM, "\tinquiry failed\n");
			num_pex_best_map_entries = 0;
			pex_best_map = (XStandardColormap *) NULL;
		}
		fprintf (STREAM, "\n");
#endif /* NEVER */


		/*
			For each visual, collect info and print out a report.
		*/

		for (vis_index = 0; vis_index < num_visuals; vis_index++) {

			report.visualid = visuals[vis_index].visualid;
			report.depth = visuals[vis_index].depth;
			report.class = visuals[vis_index].class;

			report.is_overlay = False;
			for (i = 0; i < num_ovl_visuals; i++) {
				if (visuals[vis_index].visualid == ovl_visuals[i].visualid) {
					report.is_overlay = True;
					break;
				}
			}

			for (i = 0; i < NUM_CMAP_PROPS; i++) {
				report.cmap_prop_entries[i] = NULL;
				cmap_ptr = cmap_prop_data[i];
				for (k = 0; k < cmap_entry_counts[i]; k++, cmap_ptr++) {
					if (visuals[vis_index].visualid == cmap_ptr->visualid) {
						report.cmap_prop_entries[i] = cmap_ptr;
						break;
					}
				}
			}

#ifdef NEVER
			report.pex_best_map_entry = NULL;
			for (i = 0; i < num_pex_best_map_entries; i++) {
				if (visuals[vis_index].visualid == pex_best_map[i].visualid) {
					report.pex_best_map_entry = &(pex_best_map[i]);
					break;
				}
			}
#endif


			report.pex_supported = False;
			for ( i = 0; i < NUM_ENUM_TYPES; i++ ) {
				report.enum_values[i] = NULL;
				report.enum_counts[i] = 0;
			}
			for ( i = 0; i < NUM_CONSTANTS; i++ ) {
				report.constants[i].integer = -99;
			}
			report.predefined_approx_count = 0;
			report.predefined_approx_entries = NULL;
			report.predefined_color_count = 0;

			if (pex_is_supported) {

				/*
					Determine if PEX is supported on the Visual.
				*/

				num_targets = 0;
				target_data = NULL;

				if ((ext_info->major_version == 5) &&
					(ext_info->minor_version >= 1)) {

					num_targets = 0;
					PEXMatchRenderingTargets(display, 
										RootWindow(display,screen), 
										0, PEXWindowDrawable,
										visuals[vis_index].visual, 1,
										&num_targets, &target_data);
				}
				else
					num_targets = 1;

				if (num_targets > 0)
					/* this while loop is just a substitute for goto */
					while (True) {

					report.pex_supported = True;

					/*
						Make a Colormap and a Window, for use in inquiries.
					*/

					vis_info = visuals[vis_index];

					colormap = XCreateColormap (display, 
										RootWindow(display, screen),
										vis_info.visual, AllocNone );

					if (colormap == None) {
						fprintf (stderr, 
						"ERROR:  Failed to create Colormap on Visual 0x%x\n", 
									visuals[vis_index].visualid);
						break;
					}

					window_attrs.colormap = colormap;
					window_mask = CWColormap;
					window_attrs.background_pixel = 0;
					window_mask |= CWBackPixel;
					window_attrs.border_pixel = 0;
					window_mask |= CWBorderPixel;
					window_attrs.override_redirect = True;
					window_mask |= CWOverrideRedirect;

					window = XCreateWindow (display, 
								RootWindow(display, screen),
								100, 100, 100, 100, 0,
								vis_info.depth, 
								InputOutput,
								vis_info.visual,
								window_mask,
								&window_attrs);

					XSync(display, 0);

					if (window == None) {

						fprintf (stderr, 
							"ERROR:  Failed to create Window on Visual 0x%x\n", 
										visuals[vis_index].visualid);
						break;
					}


					/*
						Inquire some enumerated types and constants of interest.
					*/

					if ( PEXGetEnumTypeInfo( display, window, 
								NUM_ENUM_TYPES, enum_types,
								PEXETAll, &enum_counts, &enum_values ) ) {
						value_ptr = enum_values;
						for ( i = 0; i < NUM_ENUM_TYPES; i++ ) {
							report.enum_values[i] = value_ptr;
							report.enum_counts[i] = enum_counts[i];
							value_ptr += enum_counts[i];
						}
					}
					else {
						fprintf (stderr, 
						"ERROR:  Failed to inquire enum types on Visual 0x%x\n",
									visuals[vis_index].visualid);

						for ( i = 0; i < NUM_ENUM_TYPES; i++ ) {
							report.enum_values[i] = NULL;
							report.enum_counts[i] = 0;
						}
						enum_counts = NULL;
						enum_values = NULL;
					}

					if (PEXGetImpDepConstants (display, window, 
								NUM_CONSTANTS, imp_dep_constants, 
								&constants)) {

						for (i=0; i<NUM_CONSTANTS; i++)
							report.constants[i] = constants[i];
					}
					else {

						fprintf (stderr, 
						"ERROR:  Failed to inquire constants on Visual 0x%x\n",
									visuals[vis_index].visualid);

						for (i=0; i<NUM_CONSTANTS; i++)
							report.constants[i].integer = -99;
						constants = NULL;
					}


					/*
						Inquire the predefined color approximation 
						table entries.
					*/

					if (PEXGetTableInfo (display, window, 
							PEXLUTColorApprox, &lut_info)) {

						report.predefined_approx_count = lut_info.predefined_count;
						if (! PEXGetPredefinedEntries (display, window, 
								PEXLUTColorApprox, 
								lut_info.predefined_min,
								lut_info.predefined_count,
								(PEXPointer *) &(report.predefined_approx_entries))) {

							fprintf (stderr, 
							"ERROR:  Failed to inquire color approx predefined entries on Visual 0x%x\n",
										visuals[vis_index].visualid);
							report.predefined_approx_entries = NULL;
							report.predefined_approx_count = 0;
						}
					}
					else {
						fprintf (stderr, 
						"ERROR:  Failed to inquire color approx table info on Visual 0x%x\n",
									visuals[vis_index].visualid);

						report.predefined_approx_count = 0;
						report.predefined_approx_entries = NULL;
					}


					/*
						Inquire the predefined entries in the color table.
					*/

					if (PEXGetTableInfo (display, window, 
							PEXLUTColor, &lut_info))
						report.predefined_color_count = lut_info.predefined_count;
					else {
						fprintf (stderr, 
						"ERROR:  Failed to inquire color table info on Visual 0x%x\n",
									visuals[vis_index].visualid);
						report.predefined_color_count = 0;
					}


					/*
						Destroy the window and colormap.
					*/

					XDestroyWindow(display, window);
					XFreeColormap (display, colormap);

					break;

				} /* while this Visual is supported as a target */
			} /* PEX is supported on the server */


			/*
				Print out information about the visual 
				and the color support for it.
			*/

			fprintf (STREAM, "-------------------------------\n");
			fprintf (STREAM, "Visual ID: 0x%x\n", report.visualid);

			fprintf (STREAM, "\tdepth: %d\n", report.depth);

			class_name = "Unrecognized class";
			for (i=0; i<NUM_VISUAL_CLASSES; i++) {
				if (visual_class_names[i].class == report.class) {
					class_name = visual_class_names[i].class_name;
					break;
				}
			}
			fprintf(STREAM, "\tclass: %s\n", class_name);

			fprintf(STREAM, "\tis_overlay: %d\n", report.is_overlay);
			fprintf(STREAM, "\tPEX_supported: %d\n", report.pex_supported);
			fprintf(STREAM, "\n");

			for (i = 0; i < NUM_CMAP_PROPS; i++) {
				if (report.cmap_prop_entries[i] != NULL) {
					fprintf(STREAM, "\t%s: yes\n", cmap_prop_names[i]);
					dump_std_colormap (report.cmap_prop_entries[i]);
				}
				else
					fprintf(STREAM, "\t%s: no\n", cmap_prop_names[i]);
				fprintf(STREAM, "\n");
			}

#ifdef NEVER
			if (report.pex_best_map_entry != NULL) {
				fprintf(STREAM, "\tPEX_BEST_MAP: yes\n");
				dump_std_colormap (report.pex_best_map_entry);
			}
			else
				fprintf(STREAM, "\tPEX_BEST_MAP: no\n");
			fprintf(STREAM, "\n");
#endif

			if (report.pex_supported) {

				for (i=0; i<NUM_ENUM_TYPES; i++) {
					fprintf (STREAM, "\tEnum type %s:\n", enum_names[i]);
					for (k=0; k < report.enum_counts[i]; k++) {
						fprintf (STREAM, "\t\t%d: %s\n", 
								report.enum_values[i][k].index,
								report.enum_values[i][k].descriptor);
					}
				}
				if (enum_values != NULL)
					PEXFreeEnumInfo( NUM_ENUM_TYPES, enum_counts, enum_values );
				enum_counts = NULL;
				enum_values = NULL;
				fprintf(STREAM, "\n");

				for (i=0; i<NUM_CONSTANTS; i++) {
					fprintf (STREAM, "\tConstant %s: ",
							constant_names[i]);
					if (imp_dep_constants[i] == PEXIDBestColorApprox) {
						best_color_approx_name = "Unrecognized value";
						for (k=0; k<NUM_BEST_COLOR_APPROX_NAMES; k++) {
							if (best_color_approx_names[k].value == 
									report.constants[i].integer) {
								best_color_approx_name = 
									best_color_approx_names[k].name;
								break;
							}
						}
						fprintf(STREAM, "%s\n", best_color_approx_name);
					}
					else 
						fprintf(STREAM, "%d\n", report.constants[i].integer);
				}
				if (constants != NULL)
					XFree (constants);
				constants = NULL;
				fprintf(STREAM, "\n");

				fprintf(STREAM, "\tPredefined_approx_count: %d\n", 
								report.predefined_approx_count);
				for (i=0; i<report.predefined_approx_count; i++) {
					dump_colorapprox_entry (&(report.predefined_approx_entries[i]));
					fprintf(STREAM, "\n");
				}
				fprintf(STREAM, "\n");

				if (report.predefined_approx_count > 0)
					PEXFreeTableEntries (PEXLUTColorApprox, 
								report.predefined_approx_count, 
								(PEXPointer) report.predefined_approx_entries);

				fprintf(STREAM, "\tPredefined_color_count: %d\n", 
								report.predefined_color_count);

				if (target_data != NULL) 
					XFree (target_data);
				num_targets = 0;
			}
		
		} /* for each Visual */

		for (i = 0; i < NUM_CMAP_PROPS; i++) {
			if (cmap_prop_data[i] != NULL) 
				XFree(cmap_prop_data[i]);
			cmap_prop_data[i] = NULL;
			cmap_entry_counts[i] = 0;
		}

		if (pex_best_map != NULL) 
			XFree(pex_best_map);
		pex_best_map = NULL;
		num_pex_best_map_entries = 0;

		if (visuals != NULL) 
			XFree(visuals);
		visuals = NULL;
		num_visuals = 0;

		if (ovl_visuals != NULL) 
			XFree(ovl_visuals);
		ovl_visuals = NULL;
		num_ovl_visuals = 0;

	} /* for each screen */

	for (i=0; i<NUM_CMAP_PROPS; i++)
		XFree (cmap_prop_names[i]);

	XCloseDisplay (display);
	exit(0);

} /* color config inquiry test */


