
/*
 *                                                                            
 *  (c) Copyright Hewlett-Packard Company, 1993, Fort Collins, Colorado       
 *                                                                            
 *                            All Rights Reserved                             
 *                                                                            
 *  Permission to use, copy, modify, and distribute this software and its     
 *  documentation for any purpose and without fee is hereby granted,          
 *  provided that the above copyright notices appear in all copies and that   
 *  both the copyright notices and this permission notice appear in           
 *  supporting documentation, and that the name of Hewlett-Packard not be     
 *  used in advertising or publicity pertaining to distribution of the        
 *  software without specific, written prior permission.                      
 *                                                                            
 *  HEWLETT-PACKARD MAKES NO WARRANTY OF ANY KIND WITH REGARD TO THIS         
 *  SOFTWARE, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF        
 *  MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.  Hewlett-Packard    
 *  shall not be liable for errors contained herein or direct, indirect,      
 *  special, incidental or consequential damages in connection with the       
 *  furnishing, performance or use of this software.                          
 *
 */


#include <stdio.h>
#include <X11/Xlib.h>
#include <X11/Xutil.h>

#define STREAM stdout

static struct _visual_class_map {
	int class;
	char *class_name;
} visual_class_names[]={
	{ StaticGray, 	"StaticGray" },
	{ GrayScale, 	"GrayScale" },
	{ StaticColor, 	"StaticColor" },
	{ PseudoColor, 	"PseudoColor" },
	{ TrueColor, 	"TrueColor" },
	{ DirectColor, 	"DirectColor" },
};
#define NUM_VISUAL_CLASSES (sizeof(visual_class_names)/sizeof(struct _visual_class_map))

void dump_colormap(	Display	*display,
					XVisualInfo *vis_info,
					Colormap	colormap)
{
	XColor			colors[256];
	int				pixel;
	char			*class_name;
	int 			i;
	int				red_shift, green_shift, blue_shift;
	int				num_reds, num_greens, num_blues;
	unsigned int	temp;

	fprintf (STREAM, "\t\tColormap ID: 0x%x\n", (int) colormap);
	class_name = "Unrecognized class";
	for (i=0; i<NUM_VISUAL_CLASSES; i++) {
		if (visual_class_names[i].class == vis_info->class) {
			class_name = visual_class_names[i].class_name;
			break;
		}
	}
	fprintf (STREAM, "\t\tvisual is depth %d %s\n", vis_info->depth, class_name);
	fprintf (STREAM, "\t\tcolormap size is %d\n", vis_info->colormap_size);

	if (vis_info->class == DirectColor || 
		vis_info->class == TrueColor) {

	    red_shift = 0;
	    num_reds = 1;
	    for (temp = vis_info->red_mask; temp > 0; temp >>= 1) {
		if (temp & 1)
		    num_reds *= 2;
		else
		    red_shift++;
	    }

	    green_shift = 0;
	    num_greens = 1;
	    for (temp = vis_info->green_mask; temp > 0; temp >>= 1) {
		if (temp & 1)
		    num_greens *= 2;
		else
		    green_shift++;
	    }

	    blue_shift = 0;
	    num_blues = 1;
	    for (temp = vis_info->blue_mask; temp > 0; temp >>= 1) {
		if (temp & 1)
		    num_blues *= 2;
		else
		    blue_shift++;
	    }
	}

	for (pixel=0; pixel<vis_info->colormap_size; pixel++)  {
	    if (vis_info->class == DirectColor || 
			vis_info->class == TrueColor) {
			colors[pixel].pixel = 	(pixel << red_shift) |
									(pixel << green_shift) |
									(pixel << blue_shift);
		}
		else
			colors[pixel].pixel = pixel;
		colors[pixel].flags = DoRed | DoGreen | DoBlue;
	}
	XQueryColors(display,colormap,colors,vis_info->colormap_size);

	for (pixel=0; pixel<vis_info->colormap_size; pixel++)
	    if (vis_info->class == DirectColor || 
			vis_info->class == TrueColor) {
			fprintf(STREAM, "\t\tpixel 0x%x: (%f,%f,%f)\n",
					colors[pixel].pixel,
					1.0 * colors[pixel].red / 65535,
					1.0 * colors[pixel].green / 65535,
					1.0 * colors[pixel].blue / 65535);
		}
		else {
			fprintf(STREAM, "\t\tpixel %d: (%f,%f,%f)\n",
					colors[pixel].pixel,
					1.0 * colors[pixel].red / 65535,
					1.0 * colors[pixel].green / 65535,
					1.0 * colors[pixel].blue / 65535);
		}
}

main(argc,argv)
int argc;
char *argv[];
{
    Display *display;
    int screen;
    XWindowAttributes window_attrs;
	Window window_id = None;
	Colormap colormap_id;
	unsigned int visual_id;

	XVisualInfo *vis_info, vinfo_template;
	long vinfo_mask; 
	int nvisuals;


	if (argc > 2) {
		sscanf (argv[1], "%x", &colormap_id);
		sscanf (argv[2], "%x", &visual_id);
	}
	else if (argc > 1)
		sscanf (argv[1], "%x", &window_id);
	else {
		fprintf (stderr, "usage: %s <window_id>\n", argv[0]);
		fprintf (stderr, "       %s <colormap_id> <visual_id>\n", argv[0]);
		exit(1);
	}

    /* Open a display connection */

    if (!(display = XOpenDisplay(NULL)))
    {
        fprintf(stderr,"Can't open %s\n",getenv("DISPLAY"));
        exit(1);
    }

    screen = DefaultScreen(display);

	if (window_id != None) {
		XGetWindowAttributes(display,window_id,&window_attrs);
		colormap_id = window_attrs.colormap;
		visual_id = XVisualIDFromVisual (window_attrs.visual);
	}

	vinfo_mask = VisualIDMask;
	vinfo_template.visualid = visual_id;
	vis_info = XGetVisualInfo (display, vinfo_mask, &vinfo_template, &nvisuals);

	if (vis_info == NULL) {
		fprintf(stderr, "Failed to get visual info\n");
		exit(1);
	}

	dump_colormap(display, vis_info, colormap_id);

	XFree (vis_info);
	XCloseDisplay(display);
}
