/* win.c - an Edit_display with Wn rendering and input callbacks */

/*  Copyright 1994 Mark Russell, University of Kent at Canterbury.
 *
 *  You can do what you like with this source code as long as
 *  you don't try to make money out of it and you include an
 *  unaltered copy of this message (including the copyright).
 */

char edit_win_c_sccsid[] = "@(#)win.c	1.11 20/6/95 (UKC)";

#include <stdlib.h>
#include <ctype.h>
#include <local/wn.h>
#include <local/ukcprog.h>

#include "edit.h"
#include "win.h"

typedef struct {
	int wn;
	int fg;
	int bg;
} Wdesc;

static void wt_set_updating PROTO((char *data, bool on));
static void wt_render_text PROTO((char *data, char *font_handle,
				  Edit_flags flags,
				  int x, int y, int baseline,
				  int width, int height,
				  const char *text, int len));
static void wt_set_area PROTO((char *data,
			       int x, int y, int width, int height, bool on));
static void wt_show_cursor PROTO((char *data, char *font_handle,
				  Edit_flags flags,
				  int x, int y, int baseline,
				  int width, int height,
				  int ch, bool on));
static bool wt_copy_area PROTO((char *data,
				int old_x, int old_y, int new_x, int new_y,
				int width, int height));
static bool wt_get_selection PROTO((char *data, const char **p_bytes, 
                                    size_t *p_nbytes));

Edit_fontinfo *
edit_make_wn_fontinfo(font)
font_t *font;
{
	return edit_make_fontinfo((char *)font,
				  font->ft_width_tab,
				  font->ft_height, font->ft_baseline);
}

Edit_display *
edit_create_wn_display(wn, fg, bg, want_cursor, keep_cursor_visible)
int wn;
int fg, bg;
bool want_cursor, keep_cursor_visible;
{
	static Edit_render_ops wt_display_ops = {
		wt_set_updating,
		wt_get_selection,
		wt_render_text,
		wt_set_area,
		wt_show_cursor,
		wt_copy_area,
	};
	Wdesc *wd;
	Edit_display *d;
	
	wd = (Wdesc *)e_malloc(sizeof(Wdesc));
	wd->wn = wn;
	wd->fg = fg;
	wd->bg = bg;
	
	d = edit_create_display(want_cursor, keep_cursor_visible,
				(char *)wd, &wt_display_ops);

	return d;
}

void
edit_update_wn_window_colors(d, fg, bg)
Edit_display *d;
int fg, bg;
{
	Wdesc *wd;
	char *render_data;
	Edit_render_ops *render_ops;
       
	edit_get_render_data_and_ops(d, &render_data, &render_ops);
	wd = (Wdesc *)render_data;
	
	wd->fg = fg;
	wd->bg = bg;
}

bool
edit_update_wn_window_size(d, wn)
Edit_display *d;
int wn;
{
	int width, height;
	Wdesc *wd;
	char *render_data;
	Edit_render_ops *render_ops;
       
	edit_get_render_data_and_ops(d, &render_data, &render_ops);
	wd = (Wdesc *)render_data;
	
	wn_get_window_size(wn, &width, &height);

	if (!edit_set_display_size(d, width, height))
		return FALSE;
	
	wd->wn = wn;
	
	return TRUE;
}
	
void
edit_handle_wn_key_event(d, ev)
Edit_display *d;
event_t *ev;
{
	int ch;
	unsigned modifiers;

	ch = ev->ev_char;

	modifiers = 0;
	if (ev->ev_buttons & B_SHIFT_MASK)
		modifiers |= EDIT_SHIFT;
	if (ev->ev_buttons & B_ALT_MASK)
		modifiers |= EDIT_ALT;
	if (ev->ev_buttons & B_CONTROL_MASK)
		modifiers |= EDIT_CONTROL;
			
	switch (ch) {
	case WN_CH_LEFT_ARROW:
		ch = EDIT_LEFT_ARROW;
		break;
	case WN_CH_RIGHT_ARROW:
		ch = EDIT_RIGHT_ARROW;
		break;
	case WN_CH_UP_ARROW:
		ch = EDIT_UP_ARROW;
		break;
	case WN_CH_DOWN_ARROW:
		ch = EDIT_DOWN_ARROW;
		break;
	default:
		if (ch >= WN_CH_FUNCKEY(0) && ch <= WN_CH_FUNCKEY(35)) {
			ch = EDIT_FUNC_KEY(ch - WN_CH_FUNCKEY(0));
		}
		else {
			/*  Lose effect of keyboard modifiers.
			 */
			if (ch < 0x20) {
				ch |= '@';
				modifiers |= EDIT_CONTROL;
			}
					
			if (isupper(ch)) {
				ch = tolower(ch);
				modifiers |= EDIT_SHIFT;
			}
			else if ((unsigned char)ch == ch) {
				/*  Some of the standard keys (e.g. `#')
				 *  are obtained on most keyboards using
				 *  shift and another key (e.g. shift-3).
				 *
				 *  As far as the edit key mappings are
				 *  concerned these are not shifted.
				 */
				modifiers &= ~EDIT_SHIFT;
			}
		}
	}
			
	edit_handle_key_event(d, ch, modifiers);
}

static bool
wt_get_selection(data, p_bytes, p_nbytes)
char *data;
const char **p_bytes;
size_t *p_nbytes;
{
	int int_nbytes;

	wn_get_selection(p_bytes, &int_nbytes);
	*p_nbytes = int_nbytes;
	return TRUE;
}

static void
wt_set_updating(data, on)
char *data;
bool on;
{
	Wdesc *wd;

	wd = (Wdesc *)data;
	
	if (on)
		wn_updating_on(wd->wn);
	else
		wn_updating_off(wd->wn);
}

static void
wt_render_text(data, font_handle, flags, x, y, baseline, width, height,
	       text, len)
char *data, *font_handle;
Edit_flags flags;
int x, y, baseline, width, height;
const char *text;
int len;
{
	Wdesc *wd = (Wdesc *)data;
	font_t *font;
	int fg, bg;
	short sh_bg, sh_fg;
	
	if (flags != 0 && flags != 3) {
	  if (flags == 4)	/* RGA attempt to get colored breakpoints */
	    srcwin_get_editblock_colors(&bg, &fg);
	  else
	    if (flags == 8)
	    {
	      get_variable_colors(&sh_bg, &sh_fg);
	      bg = sh_bg;
	      fg = sh_fg;
	    }
	    else
	      if (flags == 16)
	      {
		get_value_colors(TRUE, &sh_fg, &sh_bg);
		bg = sh_bg;
		fg = sh_fg;
	      }
	      else
	      {
		fg = wd->bg;
		bg = wd->fg;
	      }
	}
	else {
	  fg = wd->fg;
	  bg = wd->bg;
	}
	
	font = (font_t *)font_handle;
	
	wn_set_area(wd->wn, x, y, width, height, bg);
	
	wn_xwrite(wd->wn, font, text, len,
		  x,  y + baseline,
		  R_RPL, fg, bg, WN_USE_BASELINE, FALSE);
}

static void
wt_set_area(data, x, y, width, height, on)
char *data;
int x, y, width, height;
bool on;
{
	Wdesc *wd = (Wdesc *)data;

	wn_set_area(wd->wn, x, y, width, height, on ? wd->fg : wd->bg);
}

static void
wt_show_cursor(data, font_handle, flags, x, y, baseline, width, height, ch, on)
char *data, *font_handle;
Edit_flags flags;
int x, y, baseline, width, height, ch;
bool on;
{
	Wdesc *wd = (Wdesc *)data;
	font_t *font;
	char c;
	int fg, bg;
	short sh_bg, sh_fg;

	c = ch;

	if (flags != 0 && flags != 3) {
	  if (flags == 4)	/* RGA attempt to get colored breakpoints */
	    srcwin_get_editblock_colors(&bg, &fg);
	  else
	    if (flags == 8)
	    {
	      get_variable_colors(&sh_bg, &sh_fg);
	      bg = sh_bg;
	      fg = sh_fg;
	    }
	    else
	      if (flags == 16)
	      {
		get_value_colors(TRUE, &sh_fg, &sh_bg);
		bg = sh_bg;
		fg = sh_fg;
	      }
	      else
	      {
		fg = wd->bg;
		bg = wd->fg;
	    }
	}
	else {
	  fg = wd->fg;
	  bg = wd->bg;
	}

	font = (font_t *)font_handle;

	wn_xwrite(wd->wn, font, &c, 1,
		  x, y + baseline,
		  R_RPL, fg, bg, WN_USE_BASELINE, FALSE);

	if (on)
		wn_set_area(wd->wn, x, y, 2, height, fg);
}

static bool
wt_copy_area(data, old_x, old_y, new_x, new_y, width, height)
char *data;
int old_x, old_y, new_x, new_y, width, height;
{
	Wdesc *wd = (Wdesc *)data;

	wn_rop(wd->wn, old_x, old_y, width, height, new_x, new_y);

	return !wn_last_rop_was_damaged(wd->wn);
}
