/*
 * Pop up or iconify the current xterm window (using its WINDOW_ID in the env)
 * or a given window id or a list of window matching names. etc...
 * A miscellany of trivial functions.
 *
 * Mark M Martin. cetia 94/01/14 r1.10 mmm@cetia.fr
 * David DiGiacomo dd@mv.us.adobe.com
 */

#ifdef __DECC
typedef char * caddr_t; 
#endif /* __DECC */
#include <X11/Xos.h>
#include <X11/Xlib.h>
#include <X11/Xutil.h>
#include <X11/Xproto.h>
#include <stdio.h>

#ifdef VMS
#include "unix_time.h"
 unsigned long int statvms;
 unsigned long int LIB$WAIT();
 float seconds;
#else
#include <sys/time.h>
#endif


char *progname;
pexit(str)char *str;{
    fprintf(stderr,"%s: %s\n",progname,str);
    exit(1);
}

usage(){
    fprintf(stderr,
	"usage: %s -display <display>\n\
	-pop -iconify -unmap\n\
	-resize w h -rows r -columns c -[r]move x y -[r]iconmove x y\n\
	-[r]warp x y -cmap <colormap> -[no]save\n\
	-name <name> -iconname <name>\n\
	-bitmap <file> -mask <file>\n\
	-[no]keyrepeat keycode ... keycode - keycode\n\
	-id <windowid> -names <initialsubstrings>... [must be last]\n",
	progname);
    exit(1);
}

enum functions{
    pop, icon, unmap, colormap,
    move, rmove, warp, rwarp,
    resize, save, nosave,
    keyrepeat, nokeyrepeat,
    name, iconname,
    rows, columns,
    iconbitmap, iconmove, riconmove,
    lastfunc	/* this must be last */
}function;
#define	FBIT(func)	(1 << (func))

static int nowindow =	/* options that dont need a window */
    FBIT(save)|FBIT(nosave)|FBIT(keyrepeat)|FBIT(nokeyrepeat)|FBIT(rwarp);

Display *display;
Window root;
int screen,tox,toy,towidth,toheight,warpx,warpy,toiconx,toicony;
Colormap cmap;
char **names;	/* -> argv list of names to avoid */
int numnames;
int keys[256];
static char *wmname;
static char *wmiconname;
static int nrows;
static int ncolumns;
static char *bitmapname;
static char *maskname;

/*
 * sleep for given millisecs for those without usleep, like us!
 */
mssleep(ms)
int ms;
{
    struct timeval tv;
    tv.tv_sec = ms/1000;
    tv.tv_usec = (ms%1000)*1000;
#ifdef VMS
    seconds = (float) tv.tv_sec;
    statvms = LIB$WAIT(&seconds);
#else
    select(0,(int*)0,(int*)0,(int*)0,&tv);
#endif /* VMS */
}
/*
 * find all windows below this and if name matches call doit on it
 */
downtree(top)
Window top;
{
    Window *child, dummy;
    unsigned int children, i;
    char **cpp, *name;
    if (XQueryTree(display, top, &dummy, &dummy, &child, &children)==0)
	pexit("XQueryTree failed");
    for (i=0; i<children; i++)
    if(XFetchName (display, child[i], &name)){
	for(cpp = names;*cpp!=0;cpp++)
	    if(strncmp(*cpp,name,strlen(*cpp))==0){
		doit(child[i]);
		break;
	    }
	XFree(name);
    }else downtree(child[i]);	/* dont go down if found a name */
    if(child)XFree((char *)child);
}
/*
 * [un]set autorepeat for individual keys
 */
setrepeat(){
    unsigned long value_mask;
    XKeyboardControl values;
    int i;

    value_mask = KBKey|KBAutoRepeatMode;
    values.auto_repeat_mode = (function&(1<<keyrepeat))?AutoRepeatModeOn:AutoRepeatModeOff;
	
    for(i=0;i<256;i++)
    if(keys[i]){
	values.key = i;
	XChangeKeyboardControl(display, value_mask, &values);
    }
}

/*
 * get window size
 */
static
getsize(window, wp, hp)
    Window window;
    int *wp, *hp;
{
    XWindowAttributes attributes;

    if (XGetWindowAttributes(display, window, &attributes) == 0)
	pexit("XGetWindowAttributes");

    *wp = attributes.width;
    *hp = attributes.height;
}

/*
 * set window size
 */
static
doresize(window, w, h)
    Window window;
    int w, h;
{
    XWindowChanges values;
    unsigned int value_mask;
    int try;
    int nw, nh;

    values.width = w;
    values.height = h;
    value_mask = CWWidth | CWHeight;

    for (try = 0; try < 2; try++) {
	if (XReconfigureWMWindow(display, window, screen, value_mask, &values) == 0)
	    pexit("resize: XReconfigureWMWindow");

	getsize(window, &nw, &nh);
	if (values.width == nw && values.height == nh)
	    return;

	/* give window manager a chance to react */
	mssleep(500);

	getsize(window, &nw, &nh);
	if (values.width == nw && values.height == nh)
	    return;
    }

    /* last chance */
    values.width += values.width - nw;
    values.height += values.height - nh;
    if (XReconfigureWMWindow(display, window, screen, value_mask, &values) == 0)
	pexit("resize: XReconfigureWMWindow 2");
}

/*
 * set row/column size
 */
static
rcresize(what, window)
    enum functions what;
    Window window;
{
    XSizeHints *hints;
    long supplied;
    int w, h;

    if (!(what & FBIT(rows)) || !(what & FBIT(columns)))
	getsize(window, &w, &h);

    if (!(hints = XAllocSizeHints()))
	pexit("XAllocSizeHints");

    if (XGetWMNormalHints(display, window, hints, &supplied) == 0)
	pexit("XGetWMNormalHints");

    if (!(supplied & PBaseSize) || !(supplied & PResizeInc))
	pexit("missing PBaseSize and/or PResizeInc hint");

    if (what & FBIT(columns))
	w = hints->base_width + hints->width_inc * ncolumns;

    if (what & FBIT(rows))
	h = hints->base_height + hints->height_inc * nrows;

    doresize(window, w, h);

    XFree(hints);
}

static
loadbitmap(window, file, pmp)
	Window window;
	char *file;
	Pixmap *pmp;
{
	unsigned int w, h;
	int xhot, yhot;

	if (XReadBitmapFile(display, window, file,
		&w, &h, pmp, &xhot, &yhot) != BitmapSuccess)
		pexit("XReadBitmapFile failed");
}

static
setbitmap(window)
	Window window;
{
	static XWMHints *hints;
	static Pixmap bitmap_pm;
	static Pixmap mask_pm;
	XWMHints *ohints;

	if (!hints) {
		if (!(hints = XAllocWMHints()) ||
			!(ohints = XAllocWMHints()))
			pexit("XAllocWMHints");

		if (bitmapname) {
			loadbitmap(window, bitmapname, &bitmap_pm);
			hints->flags |= IconPixmapHint;
			hints->icon_pixmap = bitmap_pm;
		}

		if (maskname) {
			loadbitmap(window, maskname, &mask_pm);
			hints->flags |= IconMaskHint;
			hints->icon_mask = mask_pm;
		}

		XSetCloseDownMode(display, RetainTemporary);
	}

	if (ohints = XGetWMHints(display, window)) {
		if (ohints->icon_pixmap && hints->icon_pixmap)
			XFreePixmap(display, ohints->icon_pixmap); 
		if (ohints->icon_mask && hints->icon_mask)
			XFreePixmap(display, ohints->icon_mask);
		XFree(ohints);
	}

	XSetWMHints(display, window, hints);
}

/*
 * iconify the given window, or map and raise it, or whatever
 */
doit(window)
Window window;
{
    XWindowChanges values;
    unsigned int value_mask;
    XWMHints *wmhp;
    Window child;
    enum functions f;
    int i = 0;

    f = function;
    for (i = 0; i < lastfunc; i++)
	if (f & FBIT(i))
	switch(i){
	case warp:
	    XWarpPointer(display,None,window,0,0,0,0,warpx,warpy);
	    break;
	case rwarp:
	    XWarpPointer(display,None,None,0,0,0,0,warpx,warpy);
	    break;
	case move:
	    values.x = tox;
	    values.y = toy;
	    value_mask = CWX|CWY;
	    if(XReconfigureWMWindow(display, window, screen, value_mask, &values)==0)
		pexit("move failed");
	    break;
	case rmove:
	    if(XTranslateCoordinates(display,window,root,0,0,		     
				  &values.x,&values.y,&child)==0)
		pexit("not same screen");
	    values.x += tox;
	    values.y += toy;
	    value_mask = CWX|CWY;
	    if(XReconfigureWMWindow(display, window, screen, value_mask, &values)==0)
		pexit("rmove failed");
	    break;
	case resize:
	    doresize(window, towidth, toheight);
	    break;
	case colormap:
	    XSetWindowColormap(display,window,cmap);
	    break;
	case pop:
	    XMapRaised(display,window);
	    break;
	case unmap:
	    XUnmapWindow(display,window);
	    break;
	case icon:
	    if(XIconifyWindow(display, window, screen)==0)
		pexit("iconify failed");
	    break;
	case iconmove:
	    wmhp = XGetWMHints(display,window);
	    if(wmhp==0)pexit("no WM_HINTS");
	    wmhp->flags |= IconPositionHint;
	    wmhp->icon_x = toiconx;
	    wmhp->icon_y = toicony;
	    XSetWMHints(display,window,wmhp);
	    XFree(wmhp);
	    break;
	case riconmove:
	    wmhp = XGetWMHints(display,window);
	    if(wmhp==0)pexit("no WM_HINTS");
	    if(wmhp->flags&IconPositionHint){
		wmhp->icon_x += toiconx;
		wmhp->icon_y += toicony;
		XSetWMHints(display,window,wmhp);
	    }else pexit("no current icon xy");
	    XFree(wmhp);
	    break;
	case save:
	    XForceScreenSaver(display,ScreenSaverActive);
	    break;
	case nosave:
	    XForceScreenSaver(display,ScreenSaverReset);
	    break;
	case keyrepeat:
	case nokeyrepeat:
	    setrepeat();
	    break;
	case name:
	    XStoreName(display, window, wmname);
	    break;
	case iconname:
	    XSetIconName(display, window, wmiconname);
	    break;
	case rows:
	    if (f & FBIT(columns))
		break;
	    /* fall through */
	case columns:
	    rcresize(f, window);
	    break;
	case iconbitmap:
	    setbitmap(window);
	    break;
	}
}

main(argc,argv)
    int argc;
    char **argv;
{
    Window window = 0;
    char *displayname = 0;
    extern char *getenv();
    
    progname = argv[0] + strlen(argv[0]);
    while (progname != argv[0] && progname[-1] != '/')
	progname--;

    argc--;
    while(argv++,argc-->0){
	int argvlen = strlen(*argv);
	if(argvlen<2)argvlen = 2;
	if(strcmp(*argv,"-id")==0){
	    argc--,argv++;
	    if(argc<0)usage();
	    if(sscanf(*argv,"0x%x",&window)!=1)
		window = atoi(*argv);
	}else if(strcmp(*argv,"-root")==0){
	    window = (Window) -1;
	}else if(strncmp(*argv,"-names",6)==0){
	    /* take rest of arg list */
	    names = ++argv;
	    if(*names==0)names = 0;	/* no args follow */
	    numnames = argc;
	    argc = 0;
	}else if(strncmp(*argv,"-display",argvlen)==0){
	    argc--,argv++;
	    if(argc<0)usage();
	    displayname = *argv;
	}else if(strncmp(*argv,"-colormap",argvlen)==0){
	    function |= 1<<colormap;
	    argc--,argv++;
	    if(argc<0)usage();
	    if(sscanf(*argv,"0x%x",&cmap)!=1)
		cmap = atoi(*argv);
	}else if(strcmp(*argv,"-move")==0 ||
		 strcmp(*argv,"-rmove")==0){
	    function |= 1<<(((*argv)[1]=='m')?move:rmove);
	    argc--,argv++;
	    if(argc<0)usage();
	    tox = atoi(*argv);
	    argc--,argv++;
	    if(argc<0)usage();
	    toy = atoi(*argv);
	}else if(strcmp(*argv,"-iconmove")==0 ||
		 strcmp(*argv,"-riconmove")==0){
	    function |= 1<<(((*argv)[1]=='m')?iconmove:riconmove);
	    argc--,argv++;
	    if(argc<0)usage();
	    toiconx = atoi(*argv);
	    argc--,argv++;
	    if(argc<0)usage();
	    toicony = atoi(*argv);
	}else if(strncmp(*argv,"-resize",argvlen)==0){
	    function |= 1<<resize;
	    argc--,argv++;
	    if(argc<0)usage();
	    towidth = atoi(*argv);
	    argc--,argv++;
	    if(argc<0)usage();
	    toheight = atoi(*argv);
	}else if(strcmp(*argv,"-warp")==0 ||
	     strcmp(*argv,"-rwarp")==0){
	    function |= 1<<(strcmp(*argv,"-warp")==0?warp:rwarp);
	    argc--,argv++;
	    if(argc<0)usage();
	    warpx = atoi(*argv);
	    argc--,argv++;
	    if(argc<0)usage();
	    warpy = atoi(*argv);
	}else if(strcmp(*argv,"-pop")==0){
	    function |= 1<<pop;
	}else if(strcmp(*argv,"-save")==0){
	    function |= 1<<save;
	}else if(strcmp(*argv,"-nosave")==0){
	    function |= 1<<nosave;
	}else if(strncmp(*argv,"-iconify",argvlen)==0){
	    function |= 1<<icon;
	}else if(strcmp(*argv,"-unmap")==0){
	    function |= 1<<unmap;
	}else if(strncmp(*argv,"-keyrepeat",argvlen)==0 ||
		 strncmp(*argv,"-nokeyrepeat",argvlen)==0){
	    int i;
	    function |= 1<<((*argv)[1]=='k'?keyrepeat:nokeyrepeat);
	    if(argc<=0 || (i = atoi(argv[1]))<=0)usage();
	    while(1){
		argc--,argv++;
		keys[i&0xff] = 1;
		if(argc<=0)break;
		if(strcmp(argv[1],"-")==0){
		    int from = i;
		    argc--,argv++;
		    if(argc<0 || (i = atoi(argv[1]))<=0)usage();
		    while(from<=i)keys[from++&0xff] = 1;
		    argc--,argv++;
		    if(argc<=0)break;
		}
		if((i = atoi(argv[1]))<=0)break;
	    }
	}
	else if (strcmp(*argv, "-name") == 0) {
	    function |= FBIT(name);
	    argc--,argv++;
	    if(argc<0)usage();
	    wmname = *argv;
	}
	else if (strcmp(*argv, "-iconname") == 0) {
	    function |= FBIT(iconname);
	    argc--,argv++;
	    if(argc<0)usage();
	    wmiconname = *argv;
	}
	else if (strncmp(*argv, "-rows", argvlen) == 0) {
	    function |= FBIT(rows);
	    argc--,argv++;
	    if(argc<0)usage();
	    nrows = atoi(*argv);
	}
	else if (strncmp(*argv, "-columns", argvlen) == 0) {
	    function |= FBIT(columns);
	    argc--,argv++;
	    if(argc<0)usage();
	    ncolumns = atoi(*argv);
	}
	else if (strcmp(*argv, "-bitmap") == 0) {
	    function |= FBIT(iconbitmap);
	    argc--,argv++;
	    if(argc<0)usage();
	    bitmapname = *argv;
	}
	else if (strcmp(*argv, "-mask") == 0) {
	    function |= FBIT(iconbitmap);
	    argc--,argv++;
	    if(argc<0)usage();
	    maskname = *argv;
	}
	else usage();
    }

    if(function==0)function = FBIT(pop);	/* default action */

    if(window==0){
	if(names==0){
	    char *s;
	    s = getenv("WINDOWID");
	    if(s!=0 && *s!='\0')window = atoi(s);
	    else if(function & ~nowindow)pexit("No window id");
	    else window = (Window)-1;
	}
    }else if(names!=0)usage();

    display = XOpenDisplay(displayname);
    if(display==0)pexit("could not open display");
    root = DefaultRootWindow(display);
    if(window== (Window)-1)window = root;
    screen = DefaultScreen(display);

    if(names!=0)downtree(root);
    else doit(window);
    XSync(display,True);
    (void) XCloseDisplay(display);
    exit(0);
}
