static char rcsid[] = "$Id: Button.c,v 1.5 1999/08/25 17:14:43 falk Exp $";


/*
 * Button.c - Button widget
 */

#include <stdio.h>
#include <X11/IntrinsicP.h>
#include <X11/StringDefs.h>
#include <X11/Xmu/Misc.h>
#include <X11/Xmu/CharSet.h>
#include <X11/Xmu/Converters.h>

#include "ButtonP.h"

/****************************************************************
 *
 * Full class record constant
 *
 ****************************************************************/

/* Private Data */

static char defaultTranslations[] =
	"<EnterWindow>:		highlight()	\n\
	 <FocusIn>:		highlight()	\n\
	 <LeaveWindow>:		reset()		\n\
	 <FocusOut>:		reset()		\n\
	 <BtnDown>:		switch(down)	\n\
	 <BtnUp>:		switch(up)	\n\
	 <KeyDown>space:	switch(down)	\n\
	 <KeyUp>space:		switch(up)	";

#define offset(field) XtOffsetOf(ButtonRec, button.field)
static XtResource resources[] = {
  {XtNset, XtCSet, XtRBoolean, sizeof(Boolean),
      offset(set), XtRImmediate, (XtPointer)False},
  {XtNswitchType, XtCSwitchType, XtRSwitchType, sizeof(Pixel),
      offset(switchType), XtRImmediate, (XtPointer)MomentaryOn},
  {XtNcallback, XtCCallback, XtRCallback, sizeof(XtPointer),
      offset(callbacks), XtRCallback, (XtPointer)NULL},
  {XtNstateCallback, XtCCallback, XtRCallback, sizeof(XtPointer),
      offset(stateCallbacks), XtRCallback, (XtPointer)NULL},
};
#undef offset

	/* class methods */

static	void	ButtonClassInit(), ButtonClassPartInit() ;
static	void	ButtonInit() ;
static	Boolean ButtonSet();
static	void	ButtonChangeState() ;

	/* actions */

static	void	Switch(), Reset() ;
static	void	Highlight(), Unhighlight() ;

	/* converters */

static	void	cvtStringToSwitchType() ;


static XtActionsRec actionsList[] = {
  {"switch",		Switch},
  {"highlight",		Highlight},
  {"unhighlight",	Unhighlight},
  {"reset",		Reset},
};

#define SuperClass ((CoreWidgetClass)&coreClassRec)

ButtonClassRec buttonClassRec = {
  {
    (WidgetClass) SuperClass,		/* superclass		*/
    "Button",				/* class_name		*/
    sizeof(ButtonRec),			/* size			*/
    ButtonClassInit,			/* class_initialize	*/
    ButtonClassPartInit,		/* class_part_initialize  */
    FALSE,				/* class_inited		*/
    ButtonInit,				/* initialize		*/
    NULL,				/* initialize_hook	*/
    XtInheritRealize,			/* realize		*/
    actionsList,			/* actions		*/
    XtNumber(actionsList),		/* num_actions		*/
    resources,				/* resources		*/
    XtNumber(resources),		/* resource_count	*/
    NULLQUARK,				/* xrm_class		*/
    FALSE,				/* compress_motion	*/
    TRUE,				/* compress_exposure	*/
    TRUE,				/* compress_enterleave	*/
    FALSE,				/* visible_interest	*/
    NULL,				/* destroy		*/
    XtInheritResize,			/* resize		*/
    NULL,				/* expose		*/
    ButtonSet,				/* set_values		*/
    NULL,				/* set_values_hook	*/
    XtInheritSetValuesAlmost,		/* set_values_almost	*/
    NULL,				/* get_values_hook	*/
    NULL,				/* accept_focus		*/
    XtVersion,				/* version		*/
    NULL,				/* callback_private	*/
    defaultTranslations,		/* tm_table		*/
    XtInheritQueryGeometry,		/* query_geometry	*/
    XtInheritDisplayAccelerator,	/* display_accelerator	*/
    NULL				/* extension		*/
  },  /* CoreClass fields initialization */
  {
    ButtonChangeState,			/* change_state */
    NULL,				/* extension		*/
  },  /* ButtonClass fields initialization */
};

  /* for public consumption */
WidgetClass buttonWidgetClass = (WidgetClass) &buttonClassRec;

/****************************************************************
 *
 * Private Procedures
 *
 ****************************************************************/


static	void
ButtonClassInit()
{
  if( SuperClass->core_class.class_initialize != NULL )
    SuperClass->core_class.class_initialize() ;
  XtAddConverter(XtRString, XtRSwitchType, cvtStringToSwitchType, NULL,0) ;
}


static	void
ButtonClassPartInit(class)
    WidgetClass	class ;
{
    ButtonWidgetClass	c = (ButtonWidgetClass) class ;
    ButtonWidgetClass	super = (ButtonWidgetClass) c->core_class.superclass ;

    if( c->button_class.change_state == XtInheritChangeState  ||
        c->button_class.change_state == NULL )
      c->button_class.change_state = super->button_class.change_state ;
}



/* ARGSUSED */
static void
ButtonInit(request, new, args, num_args)
  Widget request, new;
  ArgList args;
  Cardinal *num_args;
{
  ButtonWidget bw = (ButtonWidget) new;
  bw->button.state = bw->button.set ? Set : Unset ;
  if( request->core.width == 0 ) new->core.width = 1 ;
  if( request->core.height == 0 ) new->core.height = 1 ;
}



/*
 * Set specified arguments into widget
 */

/* ARGSUSED */
static Boolean
ButtonSet(current, request, new, args, num_args)
  Widget current, request, new;
  ArgList args;
  Cardinal *num_args;
{
  ButtonWidget oldbw = (ButtonWidget) current;
  ButtonWidget bw = (ButtonWidget) new;
  Bool redisplay = False;

  if( oldbw->button.set != bw->button.set )
  {
    if( bw->button.set ) bw->button.state |= Set ;
    else		 bw->button.state &= ~Set ;
    redisplay = True ;
  }

  if( oldbw->core.sensitive != bw->core.sensitive )
  {
    if( bw->core.sensitive ) bw->button.state &= ~Insensitive ;
    else {
      bw->button.state &= ~(Armed|Highlit) ;
      bw->button.state |= Insensitive ;
    }
    redisplay = True ;
  }

  return redisplay;
}


void
ButtonChangeState(w, old, new)
  Widget	w ;
  unsigned int	old, new ;
{
  if( XtIsRealized(w) && XtClass(w)->core_class.expose != NULL )
  {
    XClearWindow(XtDisplay(w), XtWindow(w)) ;
    XtClass(w)->core_class.expose(w, NULL, NULL);
  }
}








/***************************
*
*  Action Procedures
*
***************************/


	/* This is the "standard" action procedure.  It's  behavior
	 * depends on the switchType resource.
	 */


/* ARGSUSED */
static void
Switch(w,event,params,num_params)
  Widget w;
  XEvent *event;
  String *params;	/* unused */
  Cardinal *num_params; /* unused */
{
  ButtonWidget		bw = (ButtonWidget)w;
  ButtonWidgetClass	c = (ButtonWidgetClass) XtClass(w) ;
  unsigned int		old = bw->button.state ;

  if( *num_params >= 1 )
    switch( params[0][0] ) {
      case 'd':
      case 'D':
	switch( bw->button.switchType ) {
	  case MomentaryOn:
	    bw->button.set = True ;
	    bw->button.state = SetHighlit ;
	    break ;
	  case MomentaryOff:
	    bw->button.set = False ;
	    bw->button.state = UnsetHighlit ;
	    break ;
	  case Toggle:
	    bw->button.state = bw->button.set ? SetArmed : Armed ;
	    break ;
	}
	break ;
      case 'u':
      case 'U':
	switch( bw->button.switchType ) {
	  case MomentaryOn:
	    if( bw->button.set )
	      XtCallCallbackList(w, bw->button.callbacks, (XtPointer)False);
	    bw->button.set = False ;
	    bw->button.state = Highlit ;
	    break ;
	  case MomentaryOff:
	    if( !bw->button.set )
	      XtCallCallbackList(w, bw->button.callbacks, (XtPointer)True);
	    bw->button.set = True ;
	    bw->button.state = SetHighlit ;
	    break ;
	  case Toggle:
	    if( bw->button.state & Armed ) {
	      bw->button.set = !bw->button.set ;
	      bw->button.state = bw->button.set ? SetHighlit : Highlit ;
	      XtCallCallbackList(w, bw->button.callbacks,
		  (XtPointer)(int)bw->button.set);
	    }
	    break ;
	}
	break ;
    }

  if( bw->button.state != old ) {
    XtCallCallbackList(w, bw->button.stateCallbacks,
      (XtPointer)bw->button.state);
    c->button_class.change_state(w, old, bw->button.state);
  }
}






	/* This function changes the switch back to it's default
	 * state (momentary) or previous state (toggle) and redraws.
	 */

/* ARGSUSED */
static void
Reset(w,event,params,num_params)
  Widget w;
  XEvent *event;
  String *params;	/* unused */
  Cardinal *num_params; /* unused */
{
  ButtonWidget		bw = (ButtonWidget)w;
  ButtonWidgetClass	c = (ButtonWidgetClass) XtClass(w) ;
  unsigned int		old = bw->button.state ;

  switch( bw->button.switchType ) {
    case MomentaryOn:
      bw->button.set = False ;
      bw->button.state = Unset ;
      break ;
    case MomentaryOff:
      bw->button.set = True ;
      bw->button.state = Set ;
      break ;
    case Toggle:
      bw->button.state &= ~(Highlit|Armed) ;
      break ;
  }

  if( bw->button.state != old ) {
    XtCallCallbackList(w, bw->button.stateCallbacks,
      (XtPointer)bw->button.state);
    c->button_class.change_state(w, old, bw->button.state);
  }
}



/* ARGSUSED */
static void
Highlight(w,event,params,num_params)
  Widget w;
  XEvent *event;
  String *params;
  Cardinal *num_params;
{
  ButtonWidget		bw = (ButtonWidget)w;
  ButtonWidgetClass	c = (ButtonWidgetClass) XtClass(w) ;
  unsigned int		old = bw->button.state ;

  if( bw->button.state & Highlit )
    return ;

  bw->button.state |= Highlit ;
  bw->button.state &= ~Armed ;

  XtCallCallbackList(w, bw->button.stateCallbacks,
      (XtPointer)bw->button.state);

  if( bw->button.state != old ) {
    XtCallCallbackList(w, bw->button.stateCallbacks,
      (XtPointer)bw->button.state);
    c->button_class.change_state(w, old, bw->button.state);
  }
}



/* ARGSUSED */
static void
Unhighlight(w,event,params,num_params)
  Widget w;
  XEvent *event;
  String *params;	/* unused */
  Cardinal *num_params; /* unused */
{
  ButtonWidget		bw = (ButtonWidget)w;
  ButtonWidgetClass	c = (ButtonWidgetClass) XtClass(w) ;
  unsigned int		old = bw->button.state ;

  if( (bw->button.state & Highlit) )
    return ;

  bw->button.state &= ~Highlit ;

  if( bw->button.state != old ) {
    XtCallCallbackList(w, bw->button.stateCallbacks,
      (XtPointer)bw->button.state);
    c->button_class.change_state(w, old, bw->button.state);
  }
}








	/* Converters */


/* ARGSUSED */
static	void
cvtStringToSwitchType(args, num_args, fromVal, toVal)
    XrmValuePtr args;		/* unused */
    Cardinal    *num_args;	/* unused */
    XrmValuePtr fromVal ;
    XrmValuePtr toVal ;
{
    String	str = (String)fromVal->addr ;
    static SwitchType	type;

    if( XmuCompareISOLatin1(str, "momentaryon") == 0 )
      type = MomentaryOn ;
    else if( XmuCompareISOLatin1(str, "momentaryoff") == 0 )
      type = MomentaryOff ;
    else if( XmuCompareISOLatin1(str, "toggle") == 0 )
      type = Toggle ;
    else {
      XtStringConversionWarning(fromVal->addr, XtRSwitchType);
      toVal->size = 0 ;
      toVal->addr = NULL ;
      return ;
    }

    toVal->size = sizeof(type) ;
    toVal->addr = (XPointer) &type;
}
