." $Id: Button.man,v 1.4 1999/09/01 16:12:27 falk Exp $
." view with "tbl | nroff -man"
."
.TH "Button" 3 "Aug 1999" "Version 1.0" ""
.SH NAME
Button, RockerSwitch, XpmButton
.SH DESCRIPTION
The Button widget is a widget class which implements
a "generic" push-button widget.  The Button widget itself does
not draw to the screen, but is intended to be subclassed by other
widgets.  Two sample subclasses are also provided.

.P
The RockerSwitch widget is a subclass of Button which looks like
a panel rocker switch.

.P
The XpmButton widget is a subclass of Button which displays one of
several X Pixmaps, depending on its state.  XpmButton also supports
the X Shape extension, allowing arbitrarily-shaped buttons.

.SH CLASS
Core => Button
.br
Core => Button => RockerSwitch
.br
Core => Button => XpmButton

Button does not require any specific widget set, and may be combined with
any other widget set.

.SH RESOURCES

.ps -2
.TS
center box;
cBsss
lBlBlBlB
l|l|l|l.
Button
Name	Class	Type	Default
=
set	Set	Boolean	False
switchType	SwitchType	SwitchType	MomentaryOn
callback	Callback	XtCallbackList	NULL
stateCallback	Callback	XtCallbackList	NULL

.TE
.ps +2

.ps -2
.TS
center box;
cBsss
lBlBlBlB
l|l|l|l.
RockerSwitch
Name	Class	Type	Default
=
background	Background	Pixel	Black
foreground	Foreground	Pixel	Grey
beNiceToColormap	BeNiceToColormap	Boolean	False
topShadowContrast	TopShadowContrast	int	20
bottomShadowContrast	BottomShadowContrast	int	40

.TE
.ps +2

.ps -2
.TS
center box;
cBsss
lBlBlBlB
l|l|l|l.
XpmButton
Name	Class	Type	Default
=
bitmapFilePath	BitmapFilePath	String	T{
/usr/include/X11/bitmaps: /usr/include/X11/pixmaps
T}
pixDir	PixDir	String	T{
.nf
\&.:bitmaps:Bitmaps:
pixmaps:Pixmaps
.fi
T}
pixmapName	BGPixmap	Pixmap	None
unsetPixmap	Pixmap	Pixmap	None
hlPixmap	Pixmap	Pixmap	None
armPixmap	Pixmap	Pixmap	None
setPixmap	Pixmap	Pixmap	None
sethlPixmap	Pixmap	Pixmap	None
setArmPixmap	Pixmap	Pixmap	None
insensitivePixmap	Pixmap	Pixmap	None
setInsensitivePixmap	Pixmap	Pixmap	None
shapeMask	ShapeMask	Pixmap	None

.TE
.ps +2

.LP
See the \fBCore\fP widget for more resources.

.SS Descriptions

.TP
.I Set
is the widget state.
.TP
.I SwitchType
describes the behavior of the switch.  One of:
.B MomentaryOn,
.B MomentaryOff,
.B Toggle.
.TP
.I Callback
callback procedure called when the button changes state to set or
unset.
.TP
.I StateCallback
callback procedure called when the button changes state in any
way.  See Button.h for arguments to this procedure.
.TP
.I Background
background color for rocker switch.  Used to compute shadow
colors.  Probably best to always set this to black.
.TP
.I BeNiceToColormap
if True, RockerSwitch will generate shadow colors with dither
patterns rather than consuming colormap entries.
.TP
.I TopShadowContrast
controls the highlight color for the switch.  Larger values generate
brighter highlights.
.TP
.I BottomShadowContrast
controls the shadow color for the switch.  Larger values generate
darker shadows.
.TP
.I BitmapFilePath
is a ':'-seperated path of directories to search for xpm files.
.TP
.I PixDir
is another ':'-seperated path of directories to search for xpm files.
(XawXpm compatibility.)  Both paths are searched.
.TP
.I pixmapName
is the pixmap to use for the switch background.  Set to None to use
a solid background.
.TP
.I unsetPixmap
is the pixmap to use for the switch in its unset state.
.TP
.I hlPixmap
is the pixmap to use for the switch in its unset but highlit state.
.TP
.I armPixmap
is the pixmap to use for the switch in its unset but armed state.
.TP
.I setPixmap
is the pixmap to use for the switch in its set state.
.TP
.I sethlPixmap
is the pixmap to use for the switch in its set, highlit state.
.TP
.I setArmPixmap
is the pixmap to use for the switch in its set, armed state.
.TP
.I insensitivePixmap
is the pixmap to use for the switch when insensitive.
.TP
.I setInsensitivePixmap
is the pixmap to use for the switch when set and insensitive.
.TP
.I shapeMask
is the bitmap which describes the window shape.

.P
If any XpmButton pixmap is left unspecified, the XpmButton widget
will choose a reasonable substitute.  For example, if an "armed"
pixmap is unavailable, a "highlit" pixmap will be used instead,
and so on.
.P
If insensitive pixmaps are not specified, the widget will use a
50% dither pattern in the background color.

.SH PROGRAMMING NOTES
When a MomentaryOn button changes from Unset to Set or
a MomentaryOff button changes from Set to Unset or
a Toggle button changes state,
the \fBCallback\fP procs are called with the new state passed as the
data argument.  The callback only happens when the user releases the
mouse button (or space bar) over the button.
.P
The user may cancel an action by dragging the mouse out of the button
before releasing.  In this case, no callback will occur.
.P
If an application wishes to track all button actions, it may use the
\fBStateCallback\fP callback.  This callback will be passed four
flag bits in the data argument.
.P
A button state is represented by four state flags, which are passed
to \fBStateCallback\fP and (for subclasses) to \fIchange_state\fP().
These flags are defined in Button.h as follows:
.TP
.B Highlit
Indicates that the button has mouse or keyboard focus.  The button should
be drawn in some way that indicates this, such as with a border or some
other visual highlight.
.TP
.B Armed
Indicates that the button has been pressed and is ready to be activated
by being released.  The button should be drawn in some way that indicates
this, such as being drawn "indented" or some similar way.  Only Toggle
buttons are ever in the Armed state.
.TP
.B Set
Indicates that the button is in its "set" state.  The button should be
drawn accordingly, and in all cases a button in the "set" state should be
obviously different from the "unset" state.  When the button changes
its set/unset state, the \fBCallback\fP procs are called.
.TP
.B Insensitive
Indicates that the button is not accepting input.  Button should be
drawn in some sort of "dull" form.
.P
There are only eight legitimate states for a button widget.  In particular
only one of \fBHighlit\fP, \fBArmed\fP or \fBInsensitive\fP may be set.
The eight legal states are \fBUnset\fP, \fBHighlit\fP, \fBArmed\fP,
\fBSet\fP, \fBSetHighlit\fP, \fBSetArmed\fP, \fBInsensitive\fP, and
\fBSetInsensitive\fP
.P
The \fBStateCallback\fP callback is called before the button is redrawn.
This enables application code to make last-minute changes to the button
appearance if needed.



.SH AUTHOR
Edward Falk <falk@falconer.vip.best.com>

.SH COPYRIGHT
Copyright 1999 by Edward A. Falk.  This widget may be used freely in any
free software.  Source code is freely distributable provided that my name
is not removed from it.

The X Consortium, and any party obtaining a copy of these files
from the X Consortium, directly or indirectly, is granted, free of
charge, a full and unrestricted irrevocable, world-wide, paid up,
royalty-free, nonexclusive right and license to deal in this
software and documentation files (the "Software"), including
without limitation the rights to use, copy, modify, merge, publish,
distribute, sublicense, and sell copies of the Software, and to
permit persons who receive copies from any such party to do so.

